/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.EventLogSeverity;
import net.lukemurphey.nsia.eventlog.EventLogViewer;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiEventLogViewer
extends ApiHandler {
    private EventLogViewer logViewer;

    public ApiEventLogViewer(Application appRes) {
        super(appRes);
        this.logViewer = new EventLogViewer(appRes);
    }

    public EventLogViewer.EventLogEntry[] getEntries(String sessionIdentifier, EventLogViewer.EventLogFilter filter) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getEntries(filter);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public EventLogViewer.EventLogEntry getEntry(String sessionIdentifier, int entryId) throws GeneralizedException, NoSessionException, NotFoundException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getEntry(entryId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getEntriesCount(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getEntriesCount();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getEntriesCount(String sessionIdentifier, EventLogViewer.EventLogFilter filter) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getEntriesCount(filter);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getMaxEntryID(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getMaxEntryID();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getMaxEntryID(String sessionIdentifier, String contentFilter, EventLogSeverity severityFilter) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getMaxEntryID(contentFilter, severityFilter);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getMaxEntryID(String sessionIdentifier, String contentFilter) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getMaxEntryID(contentFilter);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getMaxEntryID(String sessionIdentifier, EventLogSeverity severityFilter) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getMaxEntryID(severityFilter);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getMinEntryID(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getMinEntryID();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getMinEntryID(String sessionIdentifier, String contentFilter, EventLogSeverity severityFilter) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getMinEntryID(contentFilter, severityFilter);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getMinEntryID(String sessionIdentifier, String contentFilter) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getMinEntryID(contentFilter);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int getMinEntryID(String sessionIdentifier, EventLogSeverity severityFilter) throws GeneralizedException, NoSessionException {
        this.checkSession(sessionIdentifier);
        try {
            return this.logViewer.getMinEntryID(severityFilter);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }
}

