/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.Firewall;
import net.lukemurphey.nsia.FirewallRule;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.HostAddress;
import net.lukemurphey.nsia.InetAddressRange;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiFirewallManagement
extends ApiHandler {
    private Firewall firewall;

    public ApiFirewallManagement(Application appRes) {
        super(appRes);
        this.firewall = new Firewall(this.appRes);
    }

    public void setDefaultDeny(String sessionIdentifier, boolean denyByDefault) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Firewall.Edit");
        this.firewall.setDefaultDeny(denyByDefault);
    }

    public boolean getDefaultDeny(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Firewall.View");
        return this.firewall.getDefaultDeny();
    }

    public FirewallRule[] getFirewallRules(String sessionIdentifier) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Firewall.View");
        return this.firewall.getFirewallRules();
    }

    public Firewall.Action isAllowed(String sessionIdentifier, String address) throws UnknownHostException, InsufficientPermissionException, GeneralizedException, NoSessionException {
        HostAddress inetAddress = new HostAddress(address);
        this.checkRight(sessionIdentifier, "System.Firewall.View");
        return this.firewall.isAllowed(inetAddress);
    }

    public FirewallRule[] getMatchingFirewallRules(String sessionIdentifier, String address) throws UnknownHostException, InsufficientPermissionException, GeneralizedException, NoSessionException {
        InetAddress inetAddress = InetAddress.getByName(address);
        this.checkRight(sessionIdentifier, "System.Firewall.View");
        return this.firewall.getMatchingFirewallRules(inetAddress);
    }

    public FirewallRule getFirewallRuleById(String sessionIdentifier, long ruleId) throws InsufficientPermissionException, GeneralizedException, NoSessionException, NotFoundException {
        this.checkRight(sessionIdentifier, "System.Firewall.View");
        return this.firewall.getFirewallRuleById(ruleId);
    }

    public void addFirewallRule(String sessionIdentifier, String startAddressStr, String endAddressStr, boolean ruleDeny, Date expireDate) throws DuplicateEntryException, InsufficientPermissionException, GeneralizedException, UnknownHostException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Firewall.Edit");
        Timestamp ruleExpireTime = new Timestamp(expireDate.getTime());
        InetAddress startAddress = InetAddress.getByName(startAddressStr);
        InetAddress endAddress = InetAddress.getByName(endAddressStr);
        InetAddressRange ruleAddressRange = InetAddressRange.getByRange(startAddress, endAddress);
        FirewallRule firewallRule = new FirewallRule(ruleAddressRange, ruleDeny, ruleExpireTime);
        try {
            this.firewall.addFirewallRule(firewallRule);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void removeFirewallRule(String sessionIdentifier, long ruleId) throws DuplicateEntryException, InsufficientPermissionException, GeneralizedException, UnknownHostException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Firewall.Edit");
        try {
            this.firewall.removeFirewallRule(ruleId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }
}

