/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.GroupMembershipDescriptor;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;
import net.lukemurphey.nsia.trustBoundary.SimpleGroupDescriptor;

public class ApiGroupManagement
extends ApiHandler {
    public ApiGroupManagement(Application appRes) {
        super(appRes);
    }

    public int getGroupId(String sessionIdentifier, String groupName) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkSession(sessionIdentifier);
        UserManagement.UserDescriptor userDesc = this.getUserInfo(sessionIdentifier);
        String requesterUserName = userDesc.getUserName();
        int requesterUserId = userDesc.getUserID();
        this.checkRight(sessionIdentifier, "Groups.View");
        this.checkGroupName(requesterUserName, requesterUserId, groupName);
        try {
            return this.groupManagement.getGroupID(groupName);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int addGroup(String sessionIdentifier, String groupName, String groupDescription) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        this.checkSession(sessionIdentifier);
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        String requesterUserName = userDescriptor.getUserName();
        int requesterUserId = userDescriptor.getUserID();
        this.checkRight(sessionIdentifier, "Groups.Add");
        this.checkGroupName(requesterUserName, requesterUserId, groupName);
        try {
            int newGroupId = this.groupManagement.addGroup(groupName, groupDescription);
            if (newGroupId > -1) {
                this.appRes.logEvent(EventLogMessage.EventType.GROUP_ADDED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.GROUP_ID, newGroupId));
                return newGroupId;
            }
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Add new group"), new EventLogField(EventLogField.FieldName.GROUP_NAME, groupName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return -1;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean updateGroupInfo(String sessionIdentifier, int groupId, String groupName, String groupDescription) throws InputValidationException, GeneralizedException, InsufficientPermissionException, NoSessionException {
        UserManagement.UserDescriptor userDescriptor;
        block5: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            String requesterUserName = userDescriptor.getUserName();
            int requesterUserId = userDescriptor.getUserID();
            this.checkRight(sessionIdentifier, "Groups.Edit");
            this.checkGroupName(requesterUserName, requesterUserId, groupName);
            boolean updateStatus = this.groupManagement.updateGroupInfo(groupId, groupName, groupDescription);
            if (!updateStatus) break block5;
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_MODIFIED, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.GROUP_NAME, groupName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Update group"), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean disableGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block4: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "Groups.Edit");
            if (!this.groupManagement.disableGroup(groupId)) break block4;
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_DISABLED, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_ID_INVALID, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean deleteGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block4: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "Groups.Delete");
            if (!this.groupManagement.deleteGroup(groupId)) break block4;
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_DELETED, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_ID_INVALID, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean enableGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block4: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "Groups.Edit");
            if (!this.groupManagement.enableGroup(groupId)) break block4;
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_REENABLED, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_ID_INVALID, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public SimpleGroupDescriptor getSimpleGroupDescriptor(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, NotFoundException {
        GroupManagement.GroupDescriptor groupDesc;
        this.checkSession(sessionIdentifier);
        try {
            groupDesc = this.groupManagement.getGroupDescriptor(groupId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        if (groupDesc != null) {
            return new SimpleGroupDescriptor(groupDesc);
        }
        return null;
    }

    public GroupManagement.GroupDescriptor getGroupDescriptor(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        GroupManagement.GroupDescriptor groupDescriptor;
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "Groups.View");
        try {
            groupDescriptor = this.groupManagement.getGroupDescriptor(groupId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return groupDescriptor;
    }

    public GroupManagement.GroupDescriptor getGroupDescriptor(String sessionIdentifier, String groupName) throws SQLException, NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        GroupManagement.GroupDescriptor groupDescriptor;
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "Groups.View");
        try {
            groupDescriptor = this.groupManagement.getGroupDescriptor(groupName);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return groupDescriptor;
    }

    public GroupMembershipDescriptor getGroupMembership(String sessionIdentifier, int userId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        this.checkRight(sessionIdentifier, "Groups.View");
        try {
            return this.groupManagement.getGroupMembership(userId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean addUserToGroup(String sessionIdentifier, int userId, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block5: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "Groups.Membership.Edit");
            if (!this.groupManagement.addUserToGroup(userId, groupId)) break block5;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Add user to group"), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Add user to group"), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.MESSAGE, "Group not found"), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean removeUserFromGroup(String sessionIdentifier, int userId, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block5: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "Groups.Membership.Edit");
            if (!this.groupManagement.removeUserFromGroup(userId, groupId)) break block5;
            this.appRes.logEvent(EventLogMessage.EventType.USER_REMOVED_FROM_GROUP, new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Remove user from group"), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Remove user from group"), new EventLogField(EventLogField.FieldName.GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.MESSAGE, "Group not found"), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public String resolveGroupName(String sessionIdentifier, int groupId) throws GeneralizedException, NoSessionException, NotFoundException {
        GroupManagement.GroupDescriptor groupDesc;
        this.checkSession(sessionIdentifier);
        try {
            groupDesc = this.groupManagement.getGroupDescriptor(groupId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        if (groupDesc == null) {
            return null;
        }
        return groupDesc.getGroupName();
    }

    public GroupManagement.GroupDescriptor[] getGroupDescriptors(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        GroupManagement.GroupDescriptor[] groupDescriptors;
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "Groups.View");
        try {
            groupDescriptors = this.groupManagement.getGroupDescriptors();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return groupDescriptors;
    }

    public SimpleGroupDescriptor[] getSimpleGroupDescriptors(String sessionIdentifier) throws NoSessionException, GeneralizedException {
        GroupManagement.GroupDescriptor[] groupDescriptors;
        try {
            groupDescriptors = this.groupManagement.getGroupDescriptors();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        SimpleGroupDescriptor[] simpleGroupDescs = new SimpleGroupDescriptor[groupDescriptors.length];
        int c = 0;
        while (c < groupDescriptors.length) {
            simpleGroupDescs[c] = new SimpleGroupDescriptor(groupDescriptors[c]);
            ++c;
        }
        return simpleGroupDescs;
    }
}

