/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.AccessControl;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.ObjectPermissionDescriptor;
import net.lukemurphey.nsia.RightDescriptor;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.ScanData;

public abstract class ApiHandler {
    protected Application appRes;
    protected SessionManagement sessionManagement;
    protected UserManagement userManagement;
    protected GroupManagement groupManagement;
    protected AccessControl accessControl;
    protected SiteGroupManagement siteGroupManagement;
    protected ScanData scanData;
    protected static final boolean DEFAULT_DENY = true;

    public ApiHandler(Application appRes) {
        if (appRes == null) {
            throw new IllegalArgumentException("The application resources cannot be null");
        }
        this.appRes = appRes;
        this.sessionManagement = new SessionManagement(appRes);
        this.userManagement = new UserManagement(appRes);
        this.groupManagement = new GroupManagement(appRes);
        this.accessControl = new AccessControl(appRes);
        this.siteGroupManagement = new SiteGroupManagement(appRes);
        this.scanData = new ScanData(appRes);
    }

    protected void checkSession(String sessionId) throws NoSessionException, GeneralizedException {
        SessionStatus sessionStatus;
        try {
            SessionManagement.SessionInfo sessionInfo = this.sessionManagement.getSessionInfo(sessionId);
            if (sessionInfo == null) {
                throw new NoSessionException(SessionStatus.SESSION_NULL);
            }
            sessionStatus = sessionInfo.getSessionStatus();
        }
        catch (InputValidationException e1) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionId));
            throw new GeneralizedException();
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e1);
            throw new GeneralizedException();
        }
        if (sessionStatus != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionStatus);
        }
    }

    protected boolean checkRight(String sessionIdentifier, String rightName) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.checkRight(sessionIdentifier, rightName, null);
    }

    protected boolean checkRight(String sessionIdentifier, String rightName, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        EventLogField[] fields;
        RightDescriptor acl;
        block14: {
            block13: {
                SessionManagement.SessionInfo sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
                    throw new NoSessionException(sessionInfo.getSessionStatus());
                }
                acl = null;
                try {
                    acl = this.accessControl.getUserRight(sessionInfo.getUserId(), rightName, true);
                }
                catch (NotFoundException e) {
                    acl = null;
                }
                UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
                String userName = null;
                if (user != null) {
                    userName = user.getUserName();
                }
                fields = annotation != null ? new EventLogField[]{new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.RIGHT, rightName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId())} : new EventLogField[]{new EventLogField(EventLogField.FieldName.RIGHT, rightName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId())};
                if (!user.isUnrestricted()) break block13;
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, fields);
                return true;
            }
            if (acl == null) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, fields);
                throw new InsufficientPermissionException();
            }
            if (acl.getRight() != AccessControlDescriptor.Action.PERMIT) break block14;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, fields);
            return true;
        }
        try {
            if (acl.getRight() == AccessControlDescriptor.Action.DENY) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, fields);
                throw new InsufficientPermissionException();
            }
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, fields);
            throw new InsufficientPermissionException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    protected UserManagement.UserDescriptor getUserInfo(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        SessionManagement.SessionInfo sessionInfo;
        try {
            sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
        }
        catch (InputValidationException e1) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e1);
            throw new GeneralizedException();
        }
        UserManagement.UserDescriptor user = null;
        try {
            user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            throw new NoSessionException(SessionStatus.SESSION_NULL);
        }
        return user;
    }

    protected void checkUserName(String requesterUserName, long requesterUserId, String userName) throws InputValidationException {
        if (userName == null) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_NULL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Username cannot be null", "username", "null");
        }
        if (userName.length() == 0) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Username cannot contain 0 characters", "username", userName);
        }
        Pattern nameRegex = Pattern.compile("[-A-Z0-9a-z_ .]{0,256}");
        Matcher matcher = nameRegex.matcher(userName);
        if (!matcher.matches()) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, requesterUserId));
            throw new InputValidationException("Username contains invalid characters", "username", userName);
        }
    }

    protected void checkGroupName(String requesterUserName, long requesterUserId, String groupName) throws InputValidationException {
        if (groupName == null) {
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_NAME_NULL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Group name cannot be null", "groupname", "null");
        }
        if (groupName.length() == 0) {
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_NAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Group name cannot contain 0 characters", "groupname", groupName);
        }
        Pattern nameRegex = Pattern.compile(".{1,64}");
        Matcher matcher = nameRegex.matcher(groupName);
        if (!matcher.matches()) {
            this.appRes.logEvent(EventLogMessage.EventType.GROUP_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.GROUP_NAME, groupName));
            throw new InputValidationException("Group name contains invalid characters", "groupname", groupName);
        }
    }

    protected boolean checkCreate(String sessionIdentifier, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.checkCreate(sessionIdentifier, objectId, null);
    }

    protected boolean checkCreate(String sessionIdentifier, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        String userName;
        long userId;
        ObjectPermissionDescriptor acl;
        SessionManagement.SessionInfo sessionInfo;
        block12: {
            block11: {
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
                    throw new NoSessionException(sessionInfo.getSessionStatus());
                }
                acl = this.accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                userId = sessionInfo.getUserId();
                UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
                userName = null;
                if (user != null) {
                    userName = user.getUserName();
                }
                if (!user.isUnrestricted()) break block11;
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                return true;
            }
            if (acl == null) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InsufficientPermissionException();
            }
            if (acl.getCreatePermission() != AccessControlDescriptor.Action.PERMIT) break block12;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            if (acl.getCreatePermission() == AccessControlDescriptor.Action.DENY) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InsufficientPermissionException();
            }
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            throw new InsufficientPermissionException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    protected boolean checkExecute(String sessionIdentifier, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.checkExecute(sessionIdentifier, objectId, null);
    }

    protected boolean checkExecute(String sessionIdentifier, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        String userName;
        long userId;
        ObjectPermissionDescriptor acl;
        SessionManagement.SessionInfo sessionInfo;
        block12: {
            block11: {
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
                    throw new NoSessionException(sessionInfo.getSessionStatus());
                }
                acl = this.accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                userId = sessionInfo.getUserId();
                UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
                userName = null;
                if (user != null) {
                    userName = user.getUserName();
                }
                if (!user.isUnrestricted()) break block11;
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                return true;
            }
            if (acl == null) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InsufficientPermissionException();
            }
            if (acl.getExecutePermission() != AccessControlDescriptor.Action.PERMIT) break block12;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            if (acl.getExecutePermission() == AccessControlDescriptor.Action.DENY) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InsufficientPermissionException();
            }
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            throw new InsufficientPermissionException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    protected boolean checkModify(String sessionIdentifier, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.checkModify(sessionIdentifier, objectId, null);
    }

    protected boolean checkModify(String sessionIdentifier, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        String userName;
        long userId;
        ObjectPermissionDescriptor acl;
        SessionManagement.SessionInfo sessionInfo;
        block12: {
            block11: {
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
                    throw new NoSessionException(sessionInfo.getSessionStatus());
                }
                acl = this.accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                userId = sessionInfo.getUserId();
                UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
                userName = null;
                if (user != null) {
                    userName = user.getUserName();
                }
                if (!user.isUnrestricted()) break block11;
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                return true;
            }
            if (acl == null) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InsufficientPermissionException();
            }
            if (acl.getModifyPermission() != AccessControlDescriptor.Action.PERMIT) break block12;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            if (acl.getModifyPermission() == AccessControlDescriptor.Action.DENY) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InsufficientPermissionException();
            }
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            throw new InsufficientPermissionException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    protected boolean checkControl(String sessionIdentifier, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.checkControl(sessionIdentifier, objectId, null);
    }

    protected boolean checkControl(String sessionIdentifier, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        String userName;
        ObjectPermissionDescriptor acl;
        SessionManagement.SessionInfo sessionInfo;
        block12: {
            block11: {
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
                    throw new NoSessionException(sessionInfo.getSessionStatus());
                }
                acl = this.accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
                userName = null;
                if (user != null) {
                    userName = user.getUserName();
                }
                if (!user.isUnrestricted()) break block11;
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                return true;
            }
            if (acl == null) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                throw new InsufficientPermissionException();
            }
            if (acl.getControlPermission() != AccessControlDescriptor.Action.PERMIT) break block12;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            return true;
        }
        try {
            if (acl.getControlPermission() == AccessControlDescriptor.Action.DENY) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                throw new InsufficientPermissionException();
            }
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            throw new InsufficientPermissionException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    protected boolean checkDelete(String sessionIdentifier, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.checkDelete(sessionIdentifier, objectId, null);
    }

    protected boolean checkDelete(String sessionIdentifier, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        String userName;
        ObjectPermissionDescriptor acl;
        SessionManagement.SessionInfo sessionInfo;
        block12: {
            block11: {
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
                    throw new NoSessionException(sessionInfo.getSessionStatus());
                }
                acl = this.accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
                userName = null;
                if (user != null) {
                    userName = user.getUserName();
                }
                if (!user.isUnrestricted()) break block11;
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                return true;
            }
            if (acl == null) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                throw new InsufficientPermissionException();
            }
            if (acl.getDeletePermission() != AccessControlDescriptor.Action.PERMIT) break block12;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            return true;
        }
        try {
            if (acl.getDeletePermission() == AccessControlDescriptor.Action.DENY) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                throw new InsufficientPermissionException();
            }
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            throw new InsufficientPermissionException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    protected boolean checkRead(String sessionIdentifier, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        return this.checkRead(sessionIdentifier, objectId, null);
    }

    protected boolean checkRead(String sessionIdentifier, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        String userName;
        ObjectPermissionDescriptor acl;
        SessionManagement.SessionInfo sessionInfo;
        block12: {
            block11: {
                sessionInfo = this.sessionManagement.getSessionInfo(sessionIdentifier);
                if (sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
                    throw new NoSessionException(sessionInfo.getSessionStatus());
                }
                acl = this.accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                UserManagement.UserDescriptor user = this.userManagement.getUserDescriptor(sessionInfo.getUserId());
                userName = null;
                if (user != null) {
                    userName = user.getUserName();
                }
                if (!user.isUnrestricted()) break block11;
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                return true;
            }
            if (acl == null) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                throw new InsufficientPermissionException();
            }
            if (acl.getReadPermission() != AccessControlDescriptor.Action.PERMIT) break block12;
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            return true;
        }
        try {
            if (acl.getReadPermission() == AccessControlDescriptor.Action.DENY) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                throw new InsufficientPermissionException();
            }
            this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            throw new InsufficientPermissionException();
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionIdentifier));
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }
}

