/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.RuleScanWorker;
import net.lukemurphey.nsia.ScanCallback;
import net.lukemurphey.nsia.ScannerController;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.Wildcard;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DefinitionErrorList;
import net.lukemurphey.nsia.scan.HttpSeekingScanRule;
import net.lukemurphey.nsia.scan.HttpStaticScanResult;
import net.lukemurphey.nsia.scan.HttpStaticScanRule;
import net.lukemurphey.nsia.scan.ScanException;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ScanRuleLoader;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiScannerController
extends ApiHandler {
    private ScannerController scannerController;

    public ApiScannerController(Application appRes) {
        super(appRes);
        this.scannerController = this.appRes.getScannerController();
    }

    public HttpStaticScanResult scanHttpDataHash(String sessionIdentifier, URL url, String hashAlgorithm) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException, ScanException {
        this.checkSession(sessionIdentifier);
        try {
            HttpStaticScanRule httpScan = new HttpStaticScanRule(this.appRes, 200, "", hashAlgorithm, false, url, 120);
            HttpStaticScanResult result = (HttpStaticScanResult)httpScan.doScan();
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new GeneralizedException();
        }
    }

    public boolean definitionsErrorsNoted(String sessionIdentifier) throws NoSessionException, GeneralizedException {
        this.checkSession(sessionIdentifier);
        try {
            return DefinitionErrorList.errorsNoted(this.appRes);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public DefinitionErrorList getDefinitionsErrorList(String sessionIdentifier) throws NoSessionException, GeneralizedException {
        this.checkSession(sessionIdentifier);
        try {
            return DefinitionErrorList.load(this.appRes);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public String scanRules(String sessionIdentifier, long[] rules, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException, DuplicateEntryException {
        userDescriptor = this.getUserInfo(sessionIdentifier);
        worker = new RuleScanWorker(rules);
        siteGroupID = -1L;
        try {
            var12_7 = rules;
            var11_8 = rules.length;
            var10_9 = 0;
            while (var10_9 < var11_8) {
                ruleID = var12_7[var10_9];
                if (siteGroupID == -1L) {
                    siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleID);
                }
                scanRule = ScanRuleLoader.getScanRule(ruleID);
                ruleObjectId = scanRule.getObjectId();
                this.checkExecute(sessionIdentifier, ruleObjectId, "Scan rule " + ruleID);
                ++var10_9;
            }
            this.appRes.addWorkerToQueue(worker, "Scan by user ID " + userDescriptor.getUserID() + " for SiteGroup ID " + siteGroupID);
            thread = new Thread(worker);
            thread.setName("Scanner started by user " + userDescriptor.getUserName());
            thread.start();
            return "Scan by user ID " + userDescriptor.getUserID() + " for SiteGroup ID " + siteGroupID;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (DuplicateEntryException e) {
            throw e;
        }
        catch (Exception e) {
            rulesString = new StringBuffer();
            c = 0;
            ** while (c < rules.length)
        }
lbl-1000:
        // 1 sources

        {
            if (c == 0) {
                rulesString.append("[").append(c);
            } else {
                rulesString.append(",").append(c);
            }
            ++c;
            continue;
        }
lbl41:
        // 1 sources

        rulesString.append("]");
        this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField[]{new EventLogField(EventLogField.FieldName.OPERATION, "Scan rule"), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.RULE_ID, rulesString.toString())}), (Throwable)e);
        throw new GeneralizedException();
    }

    public ScanResult scanRule(String sessionIdentifier, long ruleId, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        try {
            ScanRule scanRule = ScanRuleLoader.getScanRule(ruleId);
            long ruleObjectId = scanRule.getObjectId();
            this.checkExecute(sessionIdentifier, ruleObjectId, "Scan rule " + ruleId);
            ScanResult scanResult = this.scannerController.scanRule(ruleId, archiveResults);
            return scanResult;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Scan rule"), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.RULE_ID, ruleId)), (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean deleteRule(String sessionIdentifier, long ruleId) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        try {
            int siteGroupID = ScanRule.getAssociatedSiteGroupID(ruleId);
            SiteGroupManagement.SiteGroupDescriptor desc = this.siteGroupManagement.getGroupDescriptor(siteGroupID);
            this.checkDelete(sessionIdentifier, desc.getObjectId(), "Delete rule " + ruleId + " from site group \"" + desc.getGroupName() + "\" (" + desc.getGroupId() + ")");
            return ScanRule.deleteRule(ruleId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Delete rule"), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.RULE_ID, ruleId)), (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult[] scanSiteGroup(String sessionIdentifier, int siteGroupId, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        SiteGroupManagement.SiteGroupDescriptor siteGroupDesc;
        block4: {
            siteGroupDesc = this.siteGroupManagement.getGroupDescriptor(siteGroupId);
            if (siteGroupDesc != null) break block4;
            return null;
        }
        try {
            this.checkExecute(sessionIdentifier, siteGroupDesc.getObjectId(), "Scan all rules for site group " + siteGroupId);
            ScanResult[] scanResults = this.scannerController.scanSiteGroup(siteGroupId, archiveResults);
            return scanResults;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.OPERATION_FAILED, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult[] scanAllRules(String sessionIdentifier, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "SiteGroups.ScanAllRules");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        try {
            ScanResult[] scanResults = this.scannerController.scanAllRules(archiveResults);
            return scanResults;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Scan all rules"), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName())), (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult[] scanExpiredRules(String sessionIdentifier, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "SiteGroups.ScanAllRules");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        try {
            ScanResult[] scanResults = this.scannerController.scanExpiredRules(archiveResults);
            return scanResults;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Scan expired rules"), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName())), (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public ScanResult[] scanUpdatedRules(String sessionIdentifier, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "SiteGroups.ScanAllRules");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        try {
            ScanResult[] scanResults = this.scannerController.scanUpdatedRules(archiveResults);
            return scanResults;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (Exception e) {
            this.appRes.logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Scan updated rules"), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName())), (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public void disableScanning(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.ControlScanner");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.appRes.logEvent(EventLogMessage.EventType.SCANNER_STOPPED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
        this.scannerController.disableScanning();
    }

    public void enableScanning(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.ControlScanner");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.appRes.logEvent(EventLogMessage.EventType.SCANNER_STARTED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
        this.scannerController.enableScanning();
    }

    public int getMaxScanThreads(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.scannerController.getMaxScanThreads();
    }

    public long getPollingLoopFrequency(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.View");
        return this.scannerController.getPollingLoopFrequency();
    }

    public void setMaxScanThreads(String sessionIdentifier, int threadCount) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.scannerController.setMaxScanThreads(threadCount);
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Maximum thread count"), new EventLogField(EventLogField.FieldName.VALUE, threadCount), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName())));
    }

    public ScannerController.ScannerState getScanningState(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkSession(sessionIdentifier);
        return this.scannerController.getScanningState();
    }

    public void setPollingLoopFrequency(String sessionIdentifier, long pollingFrequency) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.checkRight(sessionIdentifier, "System.Configuration.Edit");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        this.scannerController.setPollingLoopFrequency(pollingFrequency);
        this.appRes.logEvent(new EventLogMessage(EventLogMessage.EventType.CONFIGURATION_CHANGE, new EventLogField(EventLogField.FieldName.PARAMETER, "Polling frequency"), new EventLogField(EventLogField.FieldName.VALUE, pollingFrequency), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName())));
    }

    public RuleScanWorker doSiteScan(String sessionIdentifier, URL[] seedUrls, Wildcard domainLimit, int scanLimit, int recursionDepth, boolean includeFirstLevelLinks) throws InsufficientPermissionException, GeneralizedException, NoSessionException, DuplicateEntryException {
        this.checkRight(sessionIdentifier, "System.PerformScan");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        HttpSeekingScanRule scanRule = new HttpSeekingScanRule(this.appRes, domainLimit, includeFirstLevelLinks);
        scanRule.setRecursionDepth(recursionDepth);
        scanRule.setScanCountLimit(scanLimit);
        scanRule.addSeedUrls(seedUrls);
        ScanCallback callback = new ScanCallback(this.appRes);
        scanRule.setCallback(callback);
        RuleScanWorker worker = new RuleScanWorker(scanRule);
        this.appRes.addWorkerToQueue(worker, "SiteScan/" + userDescriptor.getUserID(), userDescriptor.getUserID());
        Thread thread = new Thread(worker);
        thread.setPriority(3);
        thread.start();
        return worker;
    }
}

