/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;

public class ApiSiteGroupManagement
extends ApiHandler {
    public ApiSiteGroupManagement(Application appRes) {
        super(appRes);
    }

    private void checkSiteGroupName(String requesterUserName, long requesterUserId, String siteGroupName) throws InputValidationException {
        if (siteGroupName == null || siteGroupName.length() == 0) {
            throw new InputValidationException("Site group name is invalid (null)", "GroupName", "");
        }
        if (siteGroupName.length() == 0) {
            throw new InputValidationException("Site group name is invalid (empty string)", "GroupName", "");
        }
        Pattern groupNamePattern = Pattern.compile("[-a-zA-Z0-9.@!$ 90()]{1,64}");
        Matcher matcher = groupNamePattern.matcher(siteGroupName);
        if (!matcher.matches()) {
            throw new InputValidationException("Site group name contains invalid characters", "GroupName", siteGroupName);
        }
    }

    public long getGroupId(String sessionIdentifier, String groupName) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        this.checkSession(sessionIdentifier);
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        String requesterUserName = userDescriptor.getUserName();
        long requesterUserId = userDescriptor.getUserID();
        this.checkRight(sessionIdentifier, "SiteGroups.View");
        this.checkSiteGroupName(requesterUserName, requesterUserId, groupName);
        try {
            return this.siteGroupManagement.getGroupID(groupName);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public int addGroup(String sessionIdentifier, String groupName, String groupDescription) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        this.checkSession(sessionIdentifier);
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        String requesterUserName = userDescriptor.getUserName();
        long requesterUserId = userDescriptor.getUserID();
        this.checkRight(sessionIdentifier, "SiteGroups.Add");
        this.checkSiteGroupName(requesterUserName, requesterUserId, groupName);
        try {
            int newGroupId = this.siteGroupManagement.addGroup(groupName, groupDescription);
            if (newGroupId > -1) {
                this.appRes.logEvent(EventLogMessage.EventType.SITE_GROUP_ADDED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, groupName), new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, newGroupId));
                return newGroupId;
            }
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Add new site group"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, groupName));
            return -1;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean updateGroupInfo(String sessionIdentifier, int groupId, String groupName, String groupDescription) throws InputValidationException, GeneralizedException, InsufficientPermissionException, NoSessionException {
        UserManagement.UserDescriptor userDescriptor;
        block6: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            String requesterUserName = userDescriptor.getUserName();
            long requesterUserId = userDescriptor.getUserID();
            this.checkRight(sessionIdentifier, "SiteGroups.Edit");
            this.checkSiteGroupName(requesterUserName, requesterUserId, groupName);
            boolean updateStatus = this.siteGroupManagement.updateGroupInfo(groupId, groupName, groupDescription);
            if (!updateStatus) break block6;
            this.appRes.logEvent(EventLogMessage.EventType.SITE_GROUP_MODIFIED, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, groupName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Update site group"), new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, groupName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean deleteGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block5: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "SiteGroups.Delete");
            if (!this.siteGroupManagement.deleteGroup(groupId)) break block5;
            this.appRes.logEvent(EventLogMessage.EventType.SITE_GROUP_DELETED, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.SITE_GROUP_ID_INVALID, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean disableGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block5: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "SiteGroups.Edit");
            if (!this.siteGroupManagement.disableGroup(groupId)) break block5;
            this.appRes.logEvent(EventLogMessage.EventType.SITE_GROUP_DISABLED, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.SITE_GROUP_ID_INVALID, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public boolean enableGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block5: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "SiteGroups.Edit");
            if (!this.siteGroupManagement.enableGroup(groupId)) break block5;
            this.appRes.logEvent(EventLogMessage.EventType.SITE_GROUP_REENABLED, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.SITE_GROUP_ID_INVALID, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, groupId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public SiteGroupManagement.SiteGroupDescriptor getGroupDescriptor(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        SiteGroupManagement.SiteGroupDescriptor groupDescriptor;
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "SiteGroups.View");
        try {
            groupDescriptor = this.siteGroupManagement.getGroupDescriptor(groupId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return groupDescriptor;
    }

    public SiteGroupManagement.SiteGroupDescriptor getGroupDescriptor(String sessionIdentifier, String groupName) throws NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        SiteGroupManagement.SiteGroupDescriptor groupDescriptor;
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "SiteGroups.View");
        try {
            groupDescriptor = this.siteGroupManagement.getGroupDescriptor(groupName);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return groupDescriptor;
    }

    public SiteGroupManagement.SiteGroupDescriptor[] getGroupDescriptors(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        SiteGroupManagement.SiteGroupDescriptor[] groupDescriptors;
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "SiteGroups.View");
        try {
            groupDescriptors = this.siteGroupManagement.getGroupDescriptors();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException();
        }
        return groupDescriptors;
    }
}

