/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.trustBoundary;

import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DisallowedOperationException;
import net.lukemurphey.nsia.EmailAddress;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.LocalPasswordAuthentication;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.PasswordAuthenticationValidator;
import net.lukemurphey.nsia.PasswordInvalidException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.trustBoundary.ApiHandler;
import net.lukemurphey.nsia.trustBoundary.SimpleUserDescriptor;

public class ApiUserManagement
extends ApiHandler {
    public static final String DEFAULT_HASH_ALGORITHM = "sha-512";
    public static final long DEFAULT_HASH_ITERATION_COUNT = 10000L;

    public ApiUserManagement(Application appRes) {
        super(appRes);
    }

    public void clearAuthFailedCount(String sessionIdentifier, String userName) throws GeneralizedException, InputValidationException, InsufficientPermissionException, NoSessionException {
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "Users.Unlock");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        String requesterUserName = userDescriptor.getUserName();
        long requesterUserId = userDescriptor.getUserID();
        if (userName == null) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_NULL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Username cannot be null", "username", "null");
        }
        if (userName.length() == 0) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Username cannot contain 0 characters", "username", userName);
        }
        Pattern nameRegex = Pattern.compile("[-A-Z0-9a-z_ .]{0,256}");
        Matcher matcher = nameRegex.matcher(userName);
        if (!matcher.matches()) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            throw new InputValidationException("Username contains invalid characters", "username", userName);
        }
        try {
            this.userManagement.clearAuthFailedCount(userName);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NumericalOverflowException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Username cannot contain 0 characters", "username", userName);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public long addAccount(String sessionIdentifier, String userName, String realName, String password, String emailAddress, boolean unrestricted) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, UnknownHostException, InvalidLocalPartException, DisallowedOperationException {
        this.checkRight(sessionIdentifier, "Users.Add");
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        String requesterUserName = userDescriptor.getUserName();
        long requesterUserId = userDescriptor.getUserID();
        if (!userDescriptor.isUnrestricted() && unrestricted) {
            Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, "Attempt to create unrestricted account from restricted account"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new DisallowedOperationException("Restricted users cannot create unrestricted accounts");
        }
        if (userName == null) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_NULL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Username cannot be null", "username", "null");
        }
        if (userName.length() == 0) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Username cannot contain 0 characters", "username", userName);
        }
        Pattern nameRegex = Pattern.compile("[-A-Z0-9a-z_ .]{0,256}");
        Matcher matcher = nameRegex.matcher(userName);
        if (!matcher.matches()) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            throw new InputValidationException("Username contains invalid characters", "username", userName);
        }
        if (realName == null) {
            this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_NULL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId));
            throw new InputValidationException("Full name cannot be null", "fullname", "null");
        }
        if (realName.length() == 0) {
            this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, realName));
            throw new InputValidationException("Full name cannot contain 0 characters", "fullname", realName);
        }
        Pattern realNameRegex = Pattern.compile("[-A-Z0-9a-z_ ().]{0,256}");
        Matcher realNameMatcher = realNameRegex.matcher(realName);
        if (!realNameMatcher.matches()) {
            this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, realName));
            throw new InputValidationException("Full name contains invalid characters", "fullname", realName);
        }
        EmailAddress email = null;
        if (emailAddress != null && !emailAddress.isEmpty()) {
            try {
                email = EmailAddress.getByAddress(emailAddress);
            }
            catch (UnknownHostException e1) {
                this.appRes.logEvent(EventLogMessage.EventType.EMAIL_UNKNOWN_HOST, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.EMAIL_ADDRESS, emailAddress));
                throw e1;
            }
            catch (InvalidLocalPartException e1) {
                this.appRes.logEvent(EventLogMessage.EventType.EMAIL_LOCAL_PART_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.EMAIL_ADDRESS, emailAddress));
                throw e1;
            }
        }
        try {
            String hashAlgorithm = this.appRes.getApplicationConfiguration().getHashAlgorithm();
            if (hashAlgorithm == null) {
                this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.MESSAGE, "Hash algorithm set to null"));
                throw new IllegalArgumentException("Hash algorithm cannot be null");
            }
            if (hashAlgorithm.length() == 0) {
                this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.MESSAGE, "Hash algorithm is an empty string"));
                throw new IllegalArgumentException("Hash algorithm cannot be empty");
            }
            long iterationCount = this.appRes.getApplicationConfiguration().getHashIterations();
            long newUserId = this.userManagement.addAccount(userName, realName, password, hashAlgorithm, iterationCount, email, unrestricted);
            if (newUserId > 0L) {
                this.appRes.logEvent(EventLogMessage.EventType.USER_ADDED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, newUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
                return newUserId;
            }
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Add user account"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userName));
            return newUserId;
        }
        catch (NoSuchAlgorithmException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public String changePasswordToRandom(String sessionIdentifier, int userId, int newPasswordLength) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException {
        this.checkSession(sessionIdentifier);
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        long sessionUserId = userDescriptor.getUserID();
        if (sessionUserId == (long)userId) {
            this.checkRight(sessionIdentifier, "Users.UpdateOwnPassword");
        } else {
            this.checkRight(sessionIdentifier, "Users.UpdatePassword");
        }
        if (newPasswordLength == 0) {
            this.appRes.logEvent(EventLogMessage.EventType.PASSWORD_EMPTY, new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            throw new InputValidationException("New password cannot be empty", "PasswordLength", String.valueOf(newPasswordLength));
        }
        if (userId < 0) {
            this.appRes.logEvent(EventLogMessage.EventType.USER_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            throw new InputValidationException("User ID is illegal", "User ID", String.valueOf(userId));
        }
        try {
            return this.userManagement.changePasswordToRandom(userId, newPasswordLength);
        }
        catch (NoSuchAlgorithmException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public boolean changePassword(String sessionIdentifier, int userId, String newPassword, String authPassword) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, PasswordInvalidException {
        this.checkSession(sessionIdentifier);
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        int sessionUserId = userDescriptor.getUserID();
        if (sessionUserId == userId) {
            this.checkRight(sessionIdentifier, "Users.UpdateOwnPassword");
        } else {
            this.checkRight(sessionIdentifier, "Users.UpdatePassword");
        }
        if (newPassword == null) {
            this.appRes.logEvent(EventLogMessage.EventType.PASSWORD_NULL, new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            throw new InputValidationException("New password cannot be null", "Password", "null");
        }
        if (newPassword.length() == 0) {
            this.appRes.logEvent(EventLogMessage.EventType.PASSWORD_EMPTY, new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            throw new InputValidationException("New password cannot be empty", "Password", newPassword);
        }
        if (userId < 0) {
            this.appRes.logEvent(EventLogMessage.EventType.PASSWORD_EMPTY, new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()));
            throw new InputValidationException("User ID is invalid", "User ID", String.valueOf(userId));
        }
        LocalPasswordAuthentication localAuth = new LocalPasswordAuthentication(this.appRes);
        try {
            if (!localAuth.checkPassword(sessionUserId, new PasswordAuthenticationValidator(authPassword))) {
                throw new PasswordInvalidException();
            }
        }
        catch (NoSuchAlgorithmException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e1);
            throw new GeneralizedException(e1);
        }
        catch (SQLException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e1);
            throw new GeneralizedException(e1);
        }
        catch (InputValidationException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e1);
            throw new GeneralizedException(e1);
        }
        catch (NoDatabaseConnectionException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e1);
            throw new GeneralizedException(e1);
        }
        catch (NumericalOverflowException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e1);
            throw new GeneralizedException(e1);
        }
        catch (NotFoundException e1) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e1);
            throw new GeneralizedException(e1);
        }
        try {
            return this.userManagement.changePassword(userId, newPassword);
        }
        catch (NoSuchAlgorithmException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public boolean deleteAccount(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, DisallowedOperationException {
        UserManagement.UserDescriptor userDescriptor;
        block6: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            if (userDescriptor.getUserID() == userId) {
                throw new DisallowedOperationException("Users are not allowed to delete their own account");
            }
            this.checkRight(sessionIdentifier, "Users.Delete");
            if (!this.userManagement.deleteAccount(userId)) break block6;
            this.appRes.logEvent(EventLogMessage.EventType.USER_DELETED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public boolean disableAccount(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, DisallowedOperationException {
        UserManagement.UserDescriptor userDescriptor;
        block6: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            if (userDescriptor.getUserID() == userId) {
                throw new DisallowedOperationException("Users are not allowed to disable their own account");
            }
            this.checkRight(sessionIdentifier, "Users.Edit");
            if (!this.userManagement.disableAccount(userId)) break block6;
            this.appRes.logEvent(EventLogMessage.EventType.USER_DISABLED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public boolean enableAccount(String sessionIdentifier, long userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor userDescriptor;
        block5: {
            this.checkSession(sessionIdentifier);
            userDescriptor = this.getUserInfo(sessionIdentifier);
            this.checkRight(sessionIdentifier, "Users.Edit");
            if (!this.userManagement.enableAccount(userId)) break block5;
            this.appRes.logEvent(EventLogMessage.EventType.USER_REENABLED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public UserManagement.UserDescriptor getUserDescriptor(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        UserManagement.UserDescriptor queriedUserDescriptor;
        this.checkSession(sessionIdentifier);
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        if (userDescriptor.getUserID() != userId) {
            this.checkRight(sessionIdentifier, "Users.View");
        }
        try {
            queriedUserDescriptor = this.userManagement.getUserDescriptor(userId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        return queriedUserDescriptor;
    }

    public UserManagement.UserDescriptor[] getUserDescriptors(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor[] userDescriptor;
        this.checkSession(sessionIdentifier);
        this.checkRight(sessionIdentifier, "Users.View");
        try {
            userDescriptor = this.userManagement.getUserDescriptors();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        return userDescriptor;
    }

    public UserManagement.UserDescriptor getUserDescriptor(String sessionIdentifier, String userName) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, NotFoundException {
        UserManagement.UserDescriptor queriedUserDescriptor;
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        String requesterUserName = userDescriptor.getUserName();
        long requesterUserId = userDescriptor.getUserID();
        if (!requesterUserName.matches(userName)) {
            this.checkRight(sessionIdentifier, "Users.View");
        }
        this.checkUserName(requesterUserName, requesterUserId, userName);
        try {
            queriedUserDescriptor = this.userManagement.getUserDescriptor(userName);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        return queriedUserDescriptor;
    }

    public long getUserId(String sessionIdentifier, String userName) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException {
        this.checkSession(sessionIdentifier);
        UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
        String requesterUserName = userDescriptor.getUserName();
        long requesterUserId = userDescriptor.getUserID();
        if (!requesterUserName.matches(userName)) {
            this.checkRight(sessionIdentifier, "Users.View");
        }
        this.checkUserName(requesterUserName, requesterUserId, userName);
        try {
            return this.userManagement.getUserID(userName);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public boolean updateAccount(String sessionIdentifier, int userId, String userName, String realName, String emailAddress) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        return this.updateAccount(sessionIdentifier, userId, userName, realName, emailAddress, null);
    }

    public boolean updateAccount(String sessionIdentifier, int userId, boolean accountEnabled, String userName, String realName, String emailAddress) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        return this.updateAccount(sessionIdentifier, userId, userName, realName, emailAddress, null, accountEnabled);
    }

    public boolean updateAccountEx(String sessionIdentifier, int userId, boolean accountEnabled, String userName, String realName, String emailAddress, boolean unrestricted) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        UserManagement.UserDescriptor userDescriptor;
        block18: {
            userDescriptor = this.getUserInfo(sessionIdentifier);
            long requesterUserId = userDescriptor.getUserID();
            if ((long)userId != requesterUserId) {
                this.checkRight(sessionIdentifier, "Users.OwnAccount.Edit");
            } else {
                this.checkRight(sessionIdentifier, "Users.Edit");
            }
            if (!userDescriptor.isUnrestricted() && unrestricted) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.OPERATION, "Update account to unrestricted"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new DisallowedOperationException("Restricted users cannot create unrestricted accounts");
            }
            if (realName == null) {
                this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_NULL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name cannot be null", "fullname", "null");
            }
            if (realName.length() == 0) {
                this.appRes.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.REAL_NAME, realName), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name cannot contain 0 characters", "fullname", realName);
            }
            Pattern realNameRegex = Pattern.compile("[-A-Z0-9a-z_ ().]{0,256}");
            Matcher realNameMatcher = realNameRegex.matcher(realName);
            if (!realNameMatcher.matches()) {
                this.appRes.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.REAL_NAME, realName), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name contains invalid characters", "fullname", realName);
            }
            EmailAddress email = null;
            if (emailAddress != null && !emailAddress.isEmpty()) {
                try {
                    email = EmailAddress.getByAddress(emailAddress);
                }
                catch (UnknownHostException e1) {
                    this.appRes.logEvent(EventLogMessage.EventType.EMAIL_UNKNOWN_HOST, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.EMAIL_ADDRESS, emailAddress), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                    throw e1;
                }
                catch (InvalidLocalPartException e1) {
                    this.appRes.logEvent(EventLogMessage.EventType.EMAIL_LOCAL_PART_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.EMAIL_ADDRESS, emailAddress), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                    throw e1;
                }
            }
            String hashAlgorithm = this.appRes.getApplicationConfiguration().getHashAlgorithm();
            if (hashAlgorithm == null) {
                this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.MESSAGE, "Hash algorithm is null"), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new IllegalArgumentException("Hash algorithm cannot be null");
            }
            if (hashAlgorithm.length() == 0) {
                this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.MESSAGE, "Hash algorithm is an empty string"), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new IllegalArgumentException("Hash algorithm cannot be empty");
            }
            boolean updateStatus = this.userManagement.updateAccountEx(userId, userName, realName, email, unrestricted, accountEnabled);
            if (!updateStatus) break block18;
            this.appRes.logEvent(EventLogMessage.EventType.USER_MODIFIED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.OPERATION, "Update user account"), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public boolean updateAccountEx(String sessionIdentifier, int userId, String userName, String realName, String emailAddress, boolean unrestricted) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        return this.updateAccount(sessionIdentifier, userId, userName, realName, emailAddress, unrestricted);
    }

    private boolean updateAccount(String sessionIdentifier, int userId, String userName, String realName, String emailAddress, Boolean unrestricted, boolean accountEnabled) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        long requesterUserId;
        String requesterUserName;
        block18: {
            UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
            requesterUserName = userDescriptor.getUserName();
            requesterUserId = userDescriptor.getUserID();
            if ((long)userId != requesterUserId) {
                this.checkRight(sessionIdentifier, "Users.UpdateOwnPassword");
            } else {
                this.checkRight(sessionIdentifier, "Users.UpdatePassword");
            }
            if (unrestricted != null && !userDescriptor.isUnrestricted() && unrestricted.booleanValue()) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new DisallowedOperationException("Restricted users cannot create unrestricted accounts");
            }
            if (realName == null) {
                this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_NULL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.MESSAGE, "Attempt to set real name to null"), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name cannot be null", "fullname", "null");
            }
            if (realName.length() == 0) {
                this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.MESSAGE, "Attempt to set real name to empty string"), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name cannot contain 0 characters", "fullname", realName);
            }
            Pattern realNameRegex = Pattern.compile("[-A-Z0-9a-z_ ().]{0,256}");
            Matcher realNameMatcher = realNameRegex.matcher(realName);
            if (!realNameMatcher.matches()) {
                this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.REAL_NAME, realName), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name contains invalid characters", "fullname", realName);
            }
            EmailAddress email = null;
            if (emailAddress != null && !emailAddress.isEmpty()) {
                try {
                    email = EmailAddress.getByAddress(emailAddress);
                }
                catch (UnknownHostException e1) {
                    this.appRes.logEvent(EventLogMessage.EventType.EMAIL_UNKNOWN_HOST, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.EMAIL_ADDRESS, emailAddress));
                    throw e1;
                }
                catch (InvalidLocalPartException e1) {
                    this.appRes.logEvent(EventLogMessage.EventType.EMAIL_LOCAL_PART_INVALID, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.EMAIL_ADDRESS, emailAddress));
                    throw e1;
                }
            }
            String hashAlgorithm = this.appRes.getApplicationConfiguration().getHashAlgorithm();
            if (hashAlgorithm == null) {
                this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.MESSAGE, "Hash algorithm is null"));
                throw new IllegalArgumentException("Hash algorithm cannot be null");
            }
            if (hashAlgorithm.length() == 0) {
                this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.MESSAGE, "Hash algorithm is an empty string"));
                throw new IllegalArgumentException("Hash algorithm cannot be empty");
            }
            boolean updateStatus = false;
            updateStatus = unrestricted == null ? this.userManagement.updateAccount(userId, userName, realName, email, accountEnabled) : this.userManagement.updateAccountEx(userId, userName, realName, email, unrestricted, accountEnabled);
            if (!updateStatus) break block18;
            this.appRes.logEvent(EventLogMessage.EventType.USER_MODIFIED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Update user account"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    private boolean updateAccount(String sessionIdentifier, int userId, String userName, String realName, String emailAddress, Boolean unrestricted) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        long requesterUserId;
        String requesterUserName;
        block18: {
            UserManagement.UserDescriptor userDescriptor = this.getUserInfo(sessionIdentifier);
            requesterUserName = userDescriptor.getUserName();
            requesterUserId = userDescriptor.getUserID();
            if ((long)userId != requesterUserId) {
                this.checkRight(sessionIdentifier, "Users.UpdateOwnPassword");
            } else {
                this.checkRight(sessionIdentifier, "Users.UpdatePassword");
            }
            if (unrestricted != null && !userDescriptor.isUnrestricted() && unrestricted.booleanValue()) {
                this.appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.OPERATION, "update account to unrestricted"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new DisallowedOperationException("Restricted users cannot create unrestricted accounts");
            }
            if (realName == null) {
                this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_NULL, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name cannot be null", "fullname", "null");
            }
            if (realName.length() == 0) {
                this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.MESSAGE, "Real name cannot be an empty string"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name cannot contain 0 characters", "fullname", realName);
            }
            Pattern realNameRegex = Pattern.compile("[-A-Z0-9a-z_ ().]{0,256}");
            Matcher realNameMatcher = realNameRegex.matcher(realName);
            if (!realNameMatcher.matches()) {
                this.appRes.logEvent(EventLogMessage.EventType.REAL_NAME_ILLEGAL, new EventLogField(EventLogField.FieldName.REAL_NAME, realName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new InputValidationException("Full name contains invalid characters", "fullname", realName);
            }
            EmailAddress email = null;
            if (emailAddress != null && !emailAddress.isEmpty()) {
                try {
                    email = EmailAddress.getByAddress(emailAddress);
                }
                catch (UnknownHostException e1) {
                    this.appRes.logEvent(EventLogMessage.EventType.EMAIL_UNKNOWN_HOST, new EventLogField(EventLogField.FieldName.EMAIL_ADDRESS, emailAddress), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                    throw e1;
                }
                catch (InvalidLocalPartException e1) {
                    this.appRes.logEvent(EventLogMessage.EventType.EMAIL_LOCAL_PART_INVALID, new EventLogField(EventLogField.FieldName.EMAIL_ADDRESS, emailAddress), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                    throw e1;
                }
            }
            String hashAlgorithm = this.appRes.getApplicationConfiguration().getHashAlgorithm();
            if (hashAlgorithm == null) {
                this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.MESSAGE, "Hash algorithm is null"), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
                throw new IllegalArgumentException("Hash algorithm cannot be null");
            }
            if (hashAlgorithm.length() == 0) {
                this.appRes.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId), new EventLogField(EventLogField.FieldName.MESSAGE, "Hash algorithm is an empty string"));
                throw new IllegalArgumentException("Hash algorithm cannot be empty");
            }
            boolean updateStatus = false;
            updateStatus = unrestricted == null ? this.userManagement.updateAccount(userId, userName, realName, email) : this.userManagement.updateAccountEx(userId, userName, realName, email, unrestricted);
            if (!updateStatus) break block18;
            this.appRes.logEvent(EventLogMessage.EventType.USER_MODIFIED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return true;
        }
        try {
            this.appRes.logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Update user account"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, requesterUserName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, requesterUserId), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userId));
            return false;
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (InputValidationException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (IllegalArgumentException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException(e);
        }
    }

    public String resolveUserName(String sessionIdentifier, int userId) throws GeneralizedException, NoSessionException, NotFoundException {
        UserManagement.UserDescriptor userDesc;
        this.checkSession(sessionIdentifier);
        try {
            userDesc = this.userManagement.getUserDescriptor(userId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        if (userDesc == null) {
            return null;
        }
        return userDesc.getUserName();
    }

    public SimpleUserDescriptor getSimpleUserDescriptor(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, NotFoundException {
        UserManagement.UserDescriptor userDesc;
        this.checkSession(sessionIdentifier);
        try {
            userDesc = this.userManagement.getUserDescriptor(userId);
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        if (userDesc != null) {
            return new SimpleUserDescriptor(userDesc);
        }
        return null;
    }

    public SimpleUserDescriptor[] getSimpleUserDescriptors(String sessionIdentifier) throws NoSessionException, GeneralizedException {
        UserManagement.UserDescriptor[] userDescriptors;
        try {
            userDescriptors = this.userManagement.getUserDescriptors();
        }
        catch (SQLException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            this.appRes.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new GeneralizedException(e);
        }
        SimpleUserDescriptor[] simpleUserDescs = new SimpleUserDescriptor[userDescriptors.length];
        int c = 0;
        while (c < userDescriptors.length) {
            simpleUserDescs[c] = new SimpleUserDescriptor(userDescriptors[c]);
            ++c;
        }
        return simpleUserDescs;
    }
}

