/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.upgrade;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.upgrade.UpgradeFailureException;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class UpgradeProcessor
implements Comparable<UpgradeProcessor> {
    protected int version_major = 0;
    protected int version_minor = 0;
    protected int version_revision = 0;

    protected UpgradeProcessor() {
    }

    protected UpgradeProcessor(int version_major, int version_minor, int version_revision) {
        this.version_major = version_major;
        this.version_minor = version_minor;
        this.version_revision = version_revision;
    }

    public abstract boolean doUpgrade(Application var1) throws UpgradeFailureException;

    @Override
    public int compareTo(UpgradeProcessor other) {
        return this.compareTo(other.version_major, other.version_minor, other.version_revision);
    }

    public int compareTo(int other_version_major, int other_version_minor, int other_version_revision) {
        if (this.version_major != other_version_major) {
            return this.version_major - other_version_major;
        }
        if (this.version_minor != other_version_minor) {
            return this.version_minor - other_version_minor;
        }
        if (this.version_revision != other_version_revision) {
            return this.version_revision - other_version_revision;
        }
        return 0;
    }

    public boolean isBefore(int other_version_major, int other_version_minor, int other_version_revision) {
        return this.compareTo(other_version_major, other_version_minor, other_version_revision) < 0;
    }

    public boolean isAfter(int other_version_major, int other_version_minor, int other_version_revision) {
        return this.compareTo(other_version_major, other_version_minor, other_version_revision) > 0;
    }

    public boolean hasVersion() {
        return this.version_major != 0 || this.version_minor != 0 || this.version_revision != 0;
    }

    public static int compare(UpgradeProcessor o1, UpgradeProcessor o2) {
        return o1.compareTo(o2);
    }

    protected static boolean hasColumn(Application app, String table, String column) throws NoDatabaseConnectionException, SQLException {
        Connection connection = null;
        Statement statement = null;
        ResultSet result = null;
        try {
            connection = app.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
            statement = connection.prepareStatement("Select * from " + StringEscapeUtils.escapeSql((String)table));
            statement.setMaxRows(1);
            result = statement.executeQuery();
            ResultSetMetaData metaData = result.getMetaData();
            int i = 1;
            if (i <= metaData.getColumnCount()) {
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (result != null) {
                result.close();
            }
        }
        return false;
    }
}

