/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lukemurphey.nsia.upgrade.UpgradeProcessor;
import net.lukemurphey.nsia.upgrade.processors.ConvertMetaDefinitionExceptions;
import net.lukemurphey.nsia.upgrade.processors.ScanRuleCreatedTimestamps;

public class UpgraderList {
    private static UpgraderList standardList = null;
    private List<UpgradeProcessor> upgraders = new ArrayList<UpgradeProcessor>();

    public static synchronized UpgraderList getInstance() {
        if (standardList == null) {
            standardList = new UpgraderList();
            standardList.populateList();
        }
        return standardList;
    }

    private void populateList() {
        this.upgraders = new ArrayList<UpgradeProcessor>();
        this.upgraders.add(new ScanRuleCreatedTimestamps());
        this.upgraders.add(new ConvertMetaDefinitionExceptions());
        Collections.sort(this.upgraders);
    }

    public List<UpgradeProcessor> getList() {
        if (this.upgraders == null) {
            this.populateList();
        }
        return this.upgraders;
    }

    public void add(UpgradeProcessor processor) {
        this.upgraders.add(processor);
    }

    public List<UpgradeProcessor> getList(int version_major, int version_minor, int version_revision) {
        List<UpgradeProcessor> upgraders = this.getList();
        ArrayList<UpgradeProcessor> relevantUpgraders = new ArrayList<UpgradeProcessor>();
        for (UpgradeProcessor upgradeProcessor : upgraders) {
            if (upgradeProcessor.hasVersion() && !upgradeProcessor.isAfter(version_major, version_minor, version_revision)) continue;
            relevantUpgraders.add(upgradeProcessor);
        }
        return relevantUpgraders;
    }
}

