/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.upgrade.processors;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.scan.MetaDefinition;
import net.lukemurphey.nsia.upgrade.UpgradeFailureException;
import net.lukemurphey.nsia.upgrade.UpgradeProcessor;

public class ConvertMetaDefinitionExceptions
extends UpgradeProcessor {
    @Override
    public boolean doUpgrade(Application application) throws UpgradeFailureException {
        Connection conn = null;
        try {
            if (application.isUsingInternalDatabase()) {
                conn = application.getDatabaseConnection(Application.DatabaseAccessType.ADMIN);
                this.convertSubCategoryException(conn, "ContentError", "Error", "Anomaly", "Quality", true);
                this.convertCategoryException(conn, "Anomaly", "Quality");
                MetaDefinition[] metaDefinitionArray = MetaDefinition.DEFAULT_META_DEFINITIONS;
                int n = MetaDefinition.DEFAULT_META_DEFINITIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    MetaDefinition def = metaDefinitionArray[n2];
                    this.convertDefinitionException(conn, "ContentError", def.getSubCategoryName(), "Anomaly", def.getCategoryName(), def.getName(), def.getName());
                    ++n2;
                }
            }
        }
        catch (SQLException e) {
            throw new UpgradeFailureException("Exception throw while attempting to update exceptions according to the new meta-definition names", e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new UpgradeFailureException("Exception throw while attempting to update exceptions according to the new meta-definition names", e);
        }
        return true;
    }

    private int convertCategoryException(Connection conn, String oldCategoryName, String newCategoryName) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("Update DefinitionPolicy set DefinitionCategory = ? where DefinitionCategory = ? and DefinitionSubCategory is null and DefinitionName is null");
            statement.setString(1, newCategoryName);
            statement.setString(2, oldCategoryName);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private int convertSubCategoryException(Connection conn, String oldSubCategoryName, String newSubCategoryName, String oldCategoryName, String newCategoryName, boolean convertAll) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = convertAll ? conn.prepareStatement("Update DefinitionPolicy set DefinitionCategory = ?, DefinitionSubCategory = ? where DefinitionCategory = ? and DefinitionSubCategory = ?") : conn.prepareStatement("Update DefinitionPolicy set DefinitionCategory = ?, DefinitionSubCategory = ? where DefinitionCategory = ? and DefinitionSubCategory = ? and DefinitionName is null");
            statement.setString(1, newCategoryName);
            statement.setString(2, newSubCategoryName);
            statement.setString(3, oldCategoryName);
            statement.setString(4, oldSubCategoryName);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private int convertDefinitionException(Connection conn, String oldSubCategoryName, String newSubCategoryName, String oldCategoryName, String newCategoryName, String oldDefinitionName, String newDefinitionName) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement("Update DefinitionPolicy set DefinitionCategory = ?, DefinitionSubCategory = ?, DefinitionName =? where DefinitionCategory = ? and DefinitionSubCategory = ? and DefinitionName = ?");
            statement.setString(1, newCategoryName);
            statement.setString(2, newSubCategoryName);
            statement.setString(3, newDefinitionName);
            statement.setString(4, oldCategoryName);
            statement.setString(5, oldSubCategoryName);
            statement.setString(6, oldDefinitionName);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }
}

