/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Vector;

public class ContentCache {
    private Vector<ContentCacheEntry> entries = new Vector();

    public ContentCacheEntry getEntry(String name) {
        Iterator<ContentCacheEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            if (it.next().isExpired()) {
                it.remove();
                continue;
            }
            if (!it.next().getUniqueName().equalsIgnoreCase(name)) continue;
            return it.next();
        }
        return null;
    }

    public void pruneExpiredEntries() {
        Iterator<ContentCacheEntry> it = this.entries.iterator();
        while (it.hasNext()) {
            if (!it.next().isExpired()) continue;
            it.remove();
        }
    }

    public static class ContentCacheEntry {
        private String name;
        private long entry_created;
        private long entry_expires;
        private ByteBuffer bytes;

        public ContentCacheEntry(String name, int expires_in_seconds) {
            this.name = name;
            this.entry_created = System.currentTimeMillis();
            this.entry_expires = this.entry_created + (long)(1000 * expires_in_seconds);
        }

        public String getUniqueName() {
            return this.name;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.entry_expires;
        }

        public void write(String content) {
            this.bytes.put(content.getBytes());
        }
    }
}

