/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GenericUtils;
import net.lukemurphey.nsia.MimeType;
import net.lukemurphey.nsia.eventlog.EventLogMessage;

public class MediaServlet
extends HttpServlet {
    private boolean cachingEnabled = true;
    private static String JAR_FILENAME = null;
    private static final long serialVersionUID = -8746902066794712658L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response, true);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response, false);
    }

    protected void doRequest(HttpServletRequest request, HttpServletResponse response, boolean inGet) throws ServletException, IOException {
        response.setHeader("Server", "ThreatFactor NSIA 1.0");
        try {
            String requestedFilename = request.getRequestURI().substring(1);
            URL url = new URL(String.valueOf(this.getJarFileName()) + "/");
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarConnection.getJarFile();
            String negotiatedFilename = null;
            ZipEntry zipEntry = null;
            zipEntry = this.negotiateImageFile(jarFile, requestedFilename, MediaServlet.isIE6OrEarlier(request.getHeader("User-Agent")));
            if (zipEntry == null) {
                zipEntry = jarFile.getEntry(requestedFilename);
            } else {
                negotiatedFilename = zipEntry.getName();
            }
            if (zipEntry == null || zipEntry.isDirectory()) {
                this.handleFileNotFound(inGet, request, response);
                return;
            }
            int fileSize = (int)zipEntry.getSize();
            response.setContentLength(fileSize);
            if (negotiatedFilename != null) {
                response.setContentType(this.getContentType(negotiatedFilename));
            } else {
                response.setContentType(this.getContentType(request.getRequestURI()));
            }
            InputStream in = jarFile.getInputStream(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(in);
            byte[] file = new byte[fileSize];
            int bytesRead = bufferedInputStream.read(file);
            bufferedInputStream.close();
            if (bytesRead == fileSize && this.cachingEnabled) {
                SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
                Date today = new Date();
                String date = formatter.format(GenericUtils.addOrSubstractDaysFromDate(today, 365));
                response.setHeader("Expires", date);
            }
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(file);
        }
        catch (FileNotFoundException e) {
            this.handleFileNotFound(inGet, request, response);
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.WEB_ERROR, t);
        }
    }

    private void handleFileNotFound(boolean inGet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setStatus(404);
            response.getOutputStream().print("File not found");
        }
        catch (IOException iOException) {
        }
        catch (Throwable t) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.WEB_ERROR, t);
        }
    }

    private JarEntry negotiateImageFile(JarFile jarFile, String name, boolean tryToAvoidPNGs) {
        JarEntry entry = null;
        if (tryToAvoidPNGs) {
            entry = this.getJarEntry(String.valueOf(name) + ".jpg", jarFile);
            if (entry != null) {
                return entry;
            }
            entry = this.getJarEntry(String.valueOf(name) + ".gif", jarFile);
            if (entry != null) {
                return entry;
            }
            entry = this.getJarEntry(String.valueOf(name) + ".png", jarFile);
            if (entry != null) {
                return entry;
            }
        } else {
            entry = this.getJarEntry(String.valueOf(name) + ".png", jarFile);
            if (entry != null) {
                return entry;
            }
            entry = this.getJarEntry(String.valueOf(name) + ".jpg", jarFile);
            if (entry != null) {
                return entry;
            }
            entry = this.getJarEntry(String.valueOf(name) + ".gif", jarFile);
            if (entry != null) {
                return entry;
            }
        }
        return entry;
    }

    private JarEntry getJarEntry(String name, JarFile jarFile) {
        Enumeration<JarEntry> entry = jarFile.entries();
        while (entry.hasMoreElements()) {
            JarEntry jarEntry = entry.nextElement();
            if (!jarEntry.getName().equals(name)) continue;
            return jarEntry;
        }
        return null;
    }

    private String getContentType(String filename) {
        String mimeType = MimeType.getMimeTypeFromName(filename);
        if (mimeType != null) {
            return mimeType;
        }
        if (filename.endsWith("png")) {
            return "image/png";
        }
        if (filename.endsWith("css")) {
            return "text/css";
        }
        if (filename.endsWith("gif")) {
            return "image/gif";
        }
        if (filename.endsWith("jpeg")) {
            return "image/jpeg";
        }
        if (filename.endsWith("js")) {
            return "text/javascript";
        }
        if (filename.endsWith("html")) {
            return "text/html";
        }
        if (filename.endsWith("htm")) {
            return "text/html";
        }
        return "text/plain";
    }

    public static boolean isIE6OrEarlier(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("MSIE [0-6]");
        Matcher matcher = pattern.matcher(userAgent);
        return matcher.find();
    }

    private String getJarFileName() {
        if (JAR_FILENAME == null) {
            String jarFile;
            JAR_FILENAME = jarFile = "jar:file:../lib/webConsole.war!";
            return JAR_FILENAME;
        }
        return JAR_FILENAME;
    }
}

