/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web;

import java.sql.SQLException;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.SessionMessages;

public class RequestContext {
    private SessionManagement.SessionInfo session_info;
    private SessionMessages session_messages;
    private UserManagement.UserDescriptor user;

    public RequestContext() {
    }

    public RequestContext(SessionManagement.SessionInfo session_info, SessionMessages session_messages) {
        this.session_info = session_info;
        this.session_messages = session_messages;
    }

    public RequestContext(SessionMessages session_messages) {
        this.session_info = null;
        this.session_messages = session_messages;
    }

    public SessionManagement.SessionInfo getSessionInfo() {
        return this.session_info;
    }

    public UserManagement.UserDescriptor getUser() {
        if (this.user == null && this.session_info.getUserId() > 0) {
            try {
                this.user = this.getUserInfo(this.session_info.getUserId());
            }
            catch (SQLException e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            }
            catch (NoDatabaseConnectionException e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            }
            catch (NotFoundException e) {
                Application.getApplication().logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            }
        }
        return this.user;
    }

    private UserManagement.UserDescriptor getUserInfo(int userID) throws SQLException, NoDatabaseConnectionException, NotFoundException {
        UserManagement userManagement = new UserManagement(Application.getApplication());
        return userManagement.getUserDescriptor(userID);
    }

    public SessionMessages getSessionMessages() {
        return this.session_messages;
    }

    public SessionMessages.SessionMessageEntry[] getMessages() {
        return this.session_messages.getMessages(this.session_info);
    }

    public void addMessage(String message, SessionMessages.MessageSeverity sev) {
        this.session_messages.addMessage(this.session_info, message, sev);
    }
}

