/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web;

import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.AccessControl;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.ObjectPermissionDescriptor;
import net.lukemurphey.nsia.RightDescriptor;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.DashboardDefinitionErrorsPanel;
import net.lukemurphey.nsia.web.views.DashboardDefinitionsUpdate;
import net.lukemurphey.nsia.web.views.DashboardLicensePanel;
import net.lukemurphey.nsia.web.views.DashboardRefreshPanel;
import net.lukemurphey.nsia.web.views.DashboardStatusPanel;
import net.lukemurphey.nsia.web.views.DashboardTasksPanel;
import net.lukemurphey.nsia.web.views.DashboardVersionPanel;
import net.lukemurphey.nsia.web.views.LogoutView;
import net.lukemurphey.nsia.web.views.UserPasswordUpdateView;

public class Shortcuts {
    protected static final boolean DEFAULT_DENY = true;

    public static void checkRight(SessionManagement.SessionInfo sessionInfo, String rightName) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkRight(sessionInfo, rightName, null);
    }

    public static void checkRight(SessionManagement.SessionInfo sessionInfo, String rightName, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkRight(sessionInfo, rightName, false, null);
    }

    public static void checkRight(SessionManagement.SessionInfo sessionInfo, String rightName, boolean checkSession, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        if (checkSession && sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionInfo.getSessionStatus());
        }
        if (!Shortcuts.hasRight(sessionInfo, rightName, annotation)) {
            throw new InsufficientPermissionException();
        }
    }

    public static boolean hasRight(SessionManagement.SessionInfo sessionInfo, String rightName) throws GeneralizedException {
        return Shortcuts.hasRight(sessionInfo, rightName, null, true);
    }

    public static boolean hasRight(SessionManagement.SessionInfo sessionInfo, String rightName, String annotation) throws GeneralizedException {
        return Shortcuts.hasRight(sessionInfo, rightName, annotation, true);
    }

    public static boolean hasRight(SessionManagement.SessionInfo sessionInfo, String rightName, String annotation, boolean logEvent) throws GeneralizedException {
        EventLogField[] fields;
        Application appRes;
        block19: {
            RightDescriptor acl;
            block18: {
                block17: {
                    block16: {
                        appRes = Application.getApplication();
                        AccessControl accessControl = new AccessControl(appRes);
                        UserManagement userManagement = new UserManagement(appRes);
                        acl = null;
                        try {
                            acl = accessControl.getUserRight(sessionInfo.getUserId(), rightName, true);
                        }
                        catch (NotFoundException e) {
                            acl = null;
                        }
                        UserManagement.UserDescriptor user = userManagement.getUserDescriptor(sessionInfo.getUserId());
                        String userName = null;
                        if (user != null) {
                            userName = user.getUserName();
                        }
                        fields = annotation != null ? new EventLogField[]{new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.RIGHT, rightName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId())} : new EventLogField[]{new EventLogField(EventLogField.FieldName.RIGHT, rightName), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId())};
                        if (!user.isUnrestricted()) break block16;
                        if (logEvent) {
                            appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, fields);
                        }
                        return true;
                    }
                    if (acl != null) break block17;
                    if (logEvent) {
                        appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, fields);
                    }
                    return false;
                }
                if (acl.getRight() != AccessControlDescriptor.Action.PERMIT) break block18;
                if (logEvent) {
                    appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, fields);
                }
                return true;
            }
            if (acl.getRight() != AccessControlDescriptor.Action.DENY) break block19;
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, fields);
            }
            return false;
        }
        try {
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, fields);
            }
            return false;
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
    }

    public static void checkCreate(SessionManagement.SessionInfo sessionInfo, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkCreate(sessionInfo, objectId, null);
    }

    public static void checkCreate(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkCreate(sessionInfo, objectId, false, annotation);
    }

    public static void checkCreate(SessionManagement.SessionInfo sessionInfo, long objectId, boolean checkSession, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        if (checkSession && sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionInfo.getSessionStatus());
        }
        if (!Shortcuts.canCreate(sessionInfo, objectId, annotation)) {
            throw new InsufficientPermissionException();
        }
    }

    public static boolean canCreate(SessionManagement.SessionInfo sessionInfo, long objectId) throws GeneralizedException {
        return Shortcuts.canCreate(sessionInfo, objectId, null);
    }

    public static boolean canCreate(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws GeneralizedException {
        return Shortcuts.canCreate(sessionInfo, objectId, annotation, true);
    }

    public static boolean canCreate(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation, boolean logEvent) throws GeneralizedException {
        String userName;
        Application appRes;
        block17: {
            ObjectPermissionDescriptor acl;
            block16: {
                block15: {
                    block14: {
                        appRes = Application.getApplication();
                        AccessControl accessControl = new AccessControl(appRes);
                        UserManagement userManagement = new UserManagement(appRes);
                        acl = accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                        UserManagement.UserDescriptor user = userManagement.getUserDescriptor(sessionInfo.getUserId());
                        userName = null;
                        if (user != null) {
                            userName = user.getUserName();
                        }
                        if (!user.isUnrestricted()) break block14;
                        if (logEvent) {
                            appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                        }
                        return true;
                    }
                    if (acl != null) break block15;
                    if (logEvent) {
                        appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                    }
                    return false;
                }
                if (acl.getCreatePermission() != AccessControlDescriptor.Action.PERMIT) break block16;
                if (logEvent) {
                    appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                }
                return true;
            }
            if (acl.getCreatePermission() != AccessControlDescriptor.Action.DENY) break block17;
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        try {
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Create"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void checkExecute(SessionManagement.SessionInfo sessionInfo, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkExecute(sessionInfo, objectId, null);
    }

    public static void checkExecute(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkExecute(sessionInfo, objectId, false, annotation);
    }

    public static void checkExecute(SessionManagement.SessionInfo sessionInfo, long objectId, boolean checkSession, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        if (checkSession && sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionInfo.getSessionStatus());
        }
        if (!Shortcuts.canExecute(sessionInfo, objectId, annotation)) {
            throw new InsufficientPermissionException();
        }
    }

    public static boolean canExecute(SessionManagement.SessionInfo sessionInfo, long objectId) {
        return Shortcuts.canExecute(sessionInfo, objectId, null);
    }

    public static boolean canExecute(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) {
        return Shortcuts.canExecute(sessionInfo, objectId, annotation, true);
    }

    public static boolean canExecute(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation, boolean logEvent) {
        String userName;
        Application appRes;
        block17: {
            ObjectPermissionDescriptor acl;
            block16: {
                block15: {
                    block14: {
                        appRes = Application.getApplication();
                        AccessControl accessControl = new AccessControl(appRes);
                        UserManagement userManagement = new UserManagement(appRes);
                        acl = accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                        UserManagement.UserDescriptor user = userManagement.getUserDescriptor(sessionInfo.getUserId());
                        userName = null;
                        if (user != null) {
                            userName = user.getUserName();
                        }
                        if (!user.isUnrestricted()) break block14;
                        if (logEvent) {
                            appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                        }
                        return true;
                    }
                    if (acl != null) break block15;
                    if (logEvent) {
                        appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                    }
                    return false;
                }
                if (acl.getExecutePermission() != AccessControlDescriptor.Action.PERMIT) break block16;
                if (logEvent) {
                    appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                }
                return true;
            }
            if (acl.getExecutePermission() != AccessControlDescriptor.Action.DENY) break block17;
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        try {
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Execute"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            return false;
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            return false;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void checkModify(SessionManagement.SessionInfo sessionInfo, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkModify(sessionInfo, objectId, null);
    }

    public static void checkModify(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkModify(sessionInfo, objectId, false, annotation);
    }

    public static void checkModify(SessionManagement.SessionInfo sessionInfo, long objectId, boolean checkSession, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        if (checkSession && sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionInfo.getSessionStatus());
        }
        if (!Shortcuts.canModify(sessionInfo, objectId, annotation)) {
            throw new InsufficientPermissionException();
        }
    }

    public static boolean canModify(SessionManagement.SessionInfo sessionInfo, long objectId) throws GeneralizedException {
        return Shortcuts.canModify(sessionInfo, objectId, null);
    }

    public static boolean canModify(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws GeneralizedException {
        return Shortcuts.canModify(sessionInfo, objectId, annotation, true);
    }

    public static boolean canModify(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation, boolean logEvent) throws GeneralizedException {
        String userName;
        Application appRes;
        block17: {
            ObjectPermissionDescriptor acl;
            block16: {
                block15: {
                    block14: {
                        appRes = Application.getApplication();
                        AccessControl accessControl = new AccessControl(appRes);
                        UserManagement userManagement = new UserManagement(appRes);
                        acl = accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                        UserManagement.UserDescriptor user = userManagement.getUserDescriptor(sessionInfo.getUserId());
                        userName = null;
                        if (user != null) {
                            userName = user.getUserName();
                        }
                        if (!user.isUnrestricted()) break block14;
                        if (logEvent) {
                            appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                        }
                        return true;
                    }
                    if (acl != null) break block15;
                    if (logEvent) {
                        appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                    }
                    return false;
                }
                if (acl.getModifyPermission() != AccessControlDescriptor.Action.PERMIT) break block16;
                if (logEvent) {
                    appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                }
                return true;
            }
            if (acl.getModifyPermission() != AccessControlDescriptor.Action.DENY) break block17;
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        try {
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Modify"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void checkControl(SessionManagement.SessionInfo sessionInfo, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkControl(sessionInfo, objectId, null);
    }

    public static void checkControl(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkControl(sessionInfo, objectId, false, annotation);
    }

    public static void checkControl(SessionManagement.SessionInfo sessionInfo, long objectId, boolean checkSession, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        if (checkSession && sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionInfo.getSessionStatus());
        }
        if (!Shortcuts.canControl(sessionInfo, objectId, annotation)) {
            throw new InsufficientPermissionException();
        }
    }

    public static boolean canControl(SessionManagement.SessionInfo sessionInfo, long objectId) throws GeneralizedException {
        return Shortcuts.canControl(sessionInfo, objectId, null);
    }

    public static boolean canControl(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws GeneralizedException {
        return Shortcuts.canControl(sessionInfo, objectId, annotation, true);
    }

    public static boolean canControl(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation, boolean logEvent) throws GeneralizedException {
        String userName;
        Application appRes;
        block17: {
            ObjectPermissionDescriptor acl;
            block16: {
                block15: {
                    block14: {
                        appRes = Application.getApplication();
                        AccessControl accessControl = new AccessControl(appRes);
                        UserManagement userManagement = new UserManagement(appRes);
                        acl = accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                        UserManagement.UserDescriptor user = userManagement.getUserDescriptor(sessionInfo.getUserId());
                        userName = null;
                        if (user != null) {
                            userName = user.getUserName();
                        }
                        if (!user.isUnrestricted()) break block14;
                        if (logEvent) {
                            appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                        }
                        return true;
                    }
                    if (acl != null) break block15;
                    if (logEvent) {
                        appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                    }
                    return false;
                }
                if (acl.getControlPermission() != AccessControlDescriptor.Action.PERMIT) break block16;
                if (logEvent) {
                    appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                }
                return true;
            }
            if (acl.getControlPermission() != AccessControlDescriptor.Action.DENY) break block17;
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        try {
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Control"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void checkDelete(SessionManagement.SessionInfo sessionInfo, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkDelete(sessionInfo, objectId, null);
    }

    public static void checkDelete(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkDelete(sessionInfo, objectId, false, annotation);
    }

    public static void checkDelete(SessionManagement.SessionInfo sessionInfo, long objectId, boolean checkSession, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        if (checkSession && sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionInfo.getSessionStatus());
        }
        if (!Shortcuts.canDelete(sessionInfo, objectId, annotation)) {
            throw new InsufficientPermissionException();
        }
    }

    public static boolean canDelete(SessionManagement.SessionInfo sessionInfo, long objectId) throws GeneralizedException {
        return Shortcuts.canDelete(sessionInfo, objectId, null);
    }

    public static boolean canDelete(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws GeneralizedException {
        return Shortcuts.canDelete(sessionInfo, objectId, annotation, true);
    }

    public static boolean canDelete(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation, boolean logEvent) throws GeneralizedException {
        String userName;
        Application appRes;
        block17: {
            ObjectPermissionDescriptor acl;
            block16: {
                block15: {
                    block14: {
                        appRes = Application.getApplication();
                        AccessControl accessControl = new AccessControl(appRes);
                        UserManagement userManagement = new UserManagement(appRes);
                        acl = accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                        UserManagement.UserDescriptor user = userManagement.getUserDescriptor(sessionInfo.getUserId());
                        userName = null;
                        if (user != null) {
                            userName = user.getUserName();
                        }
                        if (!user.isUnrestricted()) break block14;
                        if (logEvent) {
                            appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                        }
                        return true;
                    }
                    if (acl != null) break block15;
                    if (logEvent) {
                        appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                    }
                    return false;
                }
                if (acl.getDeletePermission() != AccessControlDescriptor.Action.PERMIT) break block16;
                if (logEvent) {
                    appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                }
                return true;
            }
            if (acl.getDeletePermission() != AccessControlDescriptor.Action.DENY) break block17;
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        try {
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Delete"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void checkRead(SessionManagement.SessionInfo sessionInfo, long objectId) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkRead(sessionInfo, objectId, null);
    }

    public static void checkRead(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        Shortcuts.checkRead(sessionInfo, objectId, false, annotation);
    }

    public static void checkRead(SessionManagement.SessionInfo sessionInfo, long objectId, boolean checkSession, String annotation) throws InsufficientPermissionException, GeneralizedException, NoSessionException {
        if (checkSession && sessionInfo.getSessionStatus() != SessionStatus.SESSION_ACTIVE) {
            throw new NoSessionException(sessionInfo.getSessionStatus());
        }
        if (!Shortcuts.canRead(sessionInfo, objectId, annotation)) {
            throw new InsufficientPermissionException();
        }
    }

    public static boolean canRead(SessionManagement.SessionInfo sessionInfo, long objectId) throws GeneralizedException {
        return Shortcuts.canRead(sessionInfo, objectId, null);
    }

    public static boolean canRead(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation) throws GeneralizedException {
        return Shortcuts.canRead(sessionInfo, objectId, annotation, true);
    }

    public static boolean canRead(SessionManagement.SessionInfo sessionInfo, long objectId, String annotation, boolean logEvent) throws GeneralizedException {
        String userName;
        Application appRes;
        block17: {
            ObjectPermissionDescriptor acl;
            block16: {
                block15: {
                    block14: {
                        appRes = Application.getApplication();
                        AccessControl accessControl = new AccessControl(appRes);
                        UserManagement userManagement = new UserManagement(appRes);
                        acl = accessControl.getUserPermissions(sessionInfo.getUserId(), objectId, true);
                        UserManagement.UserDescriptor user = userManagement.getUserDescriptor(sessionInfo.getUserId());
                        userName = null;
                        if (user != null) {
                            userName = user.getUserName();
                        }
                        if (!user.isUnrestricted()) break block14;
                        if (logEvent) {
                            appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                        }
                        return true;
                    }
                    if (acl != null) break block15;
                    if (logEvent) {
                        appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                    }
                    return false;
                }
                if (acl.getReadPermission() != AccessControlDescriptor.Action.PERMIT) break block16;
                if (logEvent) {
                    appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_PERMIT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
                }
                return true;
            }
            if (acl.getReadPermission() != AccessControlDescriptor.Action.DENY) break block17;
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        try {
            if (logEvent) {
                appRes.logEvent(EventLogMessage.EventType.ACCESS_CONTROL_DENY_DEFAULT, new EventLogField(EventLogField.FieldName.MESSAGE, annotation), new EventLogField(EventLogField.FieldName.OPERATION, "Read"), new EventLogField(EventLogField.FieldName.OBJECT_ID, objectId), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, sessionInfo.getUserId()));
            }
            return false;
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NoDatabaseConnectionException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    public static void addDashboardHeaders(HttpServletRequest request, HttpServletResponse response, Map<String, Object> data) throws ViewFailedException {
        Shortcuts.addDashboardHeaders(request, response, data, null);
    }

    public static void addDashboardHeaders(HttpServletRequest request, HttpServletResponse response, Map<String, Object> data, String refresh_url) throws ViewFailedException {
        DashboardDefinitionsUpdate defs_update_panel;
        String defs_update;
        DashboardVersionPanel version_panel;
        String version_warning;
        DashboardLicensePanel license_panel;
        String license_warning;
        DashboardTasksPanel tasks_panel;
        String tasks;
        DashboardDefinitionErrorsPanel definitions_panel;
        String definition_errors;
        Vector<String> panels = new Vector<String>();
        DashboardStatusPanel status_panel = new DashboardStatusPanel();
        panels.add(status_panel.getPanel(request, data, Application.getApplication()));
        if (refresh_url != null) {
            DashboardRefreshPanel refresh_panel = new DashboardRefreshPanel();
            panels.add(refresh_panel.getPanel(request, data, refresh_url, response));
        }
        if ((definition_errors = (definitions_panel = new DashboardDefinitionErrorsPanel()).getPanel(request, data, Application.getApplication())) != null) {
            panels.add(definition_errors);
        }
        if ((tasks = (tasks_panel = new DashboardTasksPanel()).getPanel(request, data, Application.getApplication())) != null) {
            panels.add(tasks);
        }
        if ((license_warning = (license_panel = new DashboardLicensePanel()).getPanel(request, data, Application.getApplication())) != null) {
            panels.add(license_warning);
        }
        if ((version_warning = (version_panel = new DashboardVersionPanel()).getPanel(request, data, Application.getApplication())) != null) {
            panels.add(version_warning);
        }
        if ((defs_update = (defs_update_panel = new DashboardDefinitionsUpdate()).getPanel(request, data, Application.getApplication())) != null) {
            panels.add(defs_update);
        }
        data.put("dashboard_headers", panels);
    }

    public static String getPath(HttpServletRequest request) {
        if (request.getPathInfo() == null) {
            return request.getServletPath();
        }
        return String.valueOf(request.getServletPath()) + request.getPathInfo();
    }

    public static Map<String, Object> getMapWithBasics(RequestContext context, HttpServletRequest request) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (request.getParameter("isajax") != null) {
            data.put("isajax", true);
        } else {
            data.put("isajax", false);
        }
        data.put("version", Application.getVersion());
        if (Application.getBuildNumber() != null && !Application.getBuildNumber().isEmpty()) {
            data.put("build_number", Application.getBuildNumber());
        }
        data.put("request", new RequestTemplateHelper(request));
        if (context != null && context.getSessionInfo() != null) {
            data.put("session", context.getSessionInfo());
            if (context.getSessionInfo().getSessionStatus() == SessionStatus.SESSION_ACTIVE) {
                data.put("context", context);
                Vector<Link> user_options = new Vector<Link>();
                try {
                    user_options.add(new Link("[Logout]", LogoutView.getURL()));
                    user_options.add(new Link("[Change Password]", UserPasswordUpdateView.getURL(context.getUser())));
                }
                catch (URLInvalidException e) {
                    Application.getApplication().getEventLog().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.WEB_ERROR), e);
                }
                data.put("upperbar_options", user_options);
            }
        }
        return data;
    }

    public String trimSlashes(String path) {
        StringBuffer tmp = new StringBuffer(path);
        if (tmp.charAt(0) == '/' || tmp.charAt(0) == '\\') {
            tmp.deleteCharAt(0);
        }
        if (tmp.charAt(path.length() - 1) == '/' || tmp.charAt(path.length() - 1) == '\\') {
            tmp.deleteCharAt(0);
        }
        return tmp.toString();
    }

    public static void getPermissionDeniedDialog(HttpServletResponse response, Map<String, Object> data, String message, boolean showSimple) throws ViewFailedException {
        Shortcuts.getPermissionDeniedDialog(response, data, message, null, showSimple);
    }

    public static void getPermissionDeniedDialog(HttpServletResponse response, Map<String, Object> data, String message) throws ViewFailedException {
        Shortcuts.getPermissionDeniedDialog(response, data, message, null);
    }

    public static void getPermissionDeniedDialog(HttpServletResponse response, Map<String, Object> data, String message, Link link) throws ViewFailedException {
        Shortcuts.getPermissionDeniedDialog(response, data, message, link, false);
    }

    public static void getPermissionDeniedDialog(HttpServletResponse response, Map<String, Object> data, String message, Link link, boolean showSimple) throws ViewFailedException {
        data.put("permission_denied_message", message);
        data.put("permission_denied_link", link);
        data.put("show_simple", showSimple);
        TemplateLoader.renderToResponse("PermissionDenied.ftl", data, response);
    }

    public static String getBytesDescription(long bytes) {
        double bytesDouble = bytes;
        DecimalFormat twoPlaces = new DecimalFormat("0.00");
        if (bytes < 1024L) {
            return String.valueOf(bytes) + " Bytes";
        }
        if (bytes < 0x100000L) {
            return String.valueOf(twoPlaces.format(bytesDouble / 1024.0)) + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.valueOf(twoPlaces.format(bytesDouble / 1048576.0)) + " MB";
        }
        return String.valueOf(twoPlaces.format(bytesDouble / 1.073741824E9)) + " GB";
    }

    public static String getTimeDescription(long secs) {
        double doubleSecs = secs;
        DecimalFormat twoPlaces = new DecimalFormat("0.00");
        if (secs < 60L) {
            return String.valueOf(secs) + " sec";
        }
        if (secs < 3600L) {
            return String.valueOf(twoPlaces.format(doubleSecs / 60.0)) + " min";
        }
        if (secs < 86400L) {
            return String.valueOf(twoPlaces.format(doubleSecs / 3600.0)) + " hours";
        }
        return String.valueOf(twoPlaces.format(doubleSecs / 86400.0)) + " days";
    }

    public static class RequestTemplateHelper {
        private HttpServletRequest request = null;

        public RequestTemplateHelper(HttpServletRequest request) {
            this.request = request;
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public String[] getParameters(String name) {
            return this.request.getParameterValues(name);
        }

        public String getMethod() {
            return this.request.getMethod();
        }

        public String getThisURL() {
            return Shortcuts.getPath(this.request);
        }
    }
}

