/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.web.ClientAbortException;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;

public abstract class View {
    private Pattern[] arguments;
    private String base_path;
    private String[] base_path_split;
    private String name;
    private static String PATH_SPLIT_REGEX = "(/|\\\\)";

    public View(String base_path, String name, Pattern ... arguments) {
        if (base_path == null) {
            throw new IllegalArgumentException("Base path cannot be null");
        }
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The name of the View URI cannot be null or empty");
        }
        this.arguments = arguments;
        this.base_path = base_path;
        this.base_path_split = this.base_path.split(PATH_SPLIT_REGEX);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context) throws ViewFailedException, ClientAbortException {
        return this.process(request, response, context, false);
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, boolean ignore_arguments) throws ViewFailedException, ClientAbortException {
        String[] args;
        try {
            args = request.getPathInfo() == null ? this.parseArgs(request.getServletPath()) : this.parseArgs(String.valueOf(request.getServletPath()) + request.getPathInfo());
        }
        catch (URLInvalidException e) {
            if (!ignore_arguments) {
                return false;
            }
            args = new String[]{};
        }
        try {
            return this.process(request, response, context, args, Shortcuts.getMapWithBasics(context, request));
        }
        catch (IOException e) {
            throw new ClientAbortException(e);
        }
        catch (URLInvalidException e) {
            throw new ViewFailedException(e);
        }
        catch (ViewNotFoundException e) {
            throw new ViewFailedException(e);
        }
    }

    protected abstract boolean process(HttpServletRequest var1, HttpServletResponse var2, RequestContext var3, String[] var4, Map<String, Object> var5) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException;

    protected String escapeSlashes(String arg) {
        return arg;
    }

    protected String unescapeSlashes(String arg) {
        return arg;
    }

    public boolean servesRequest(HttpServletRequest request) {
        try {
            this.parseArgs(request.getPathInfo());
            return true;
        }
        catch (URLInvalidException e) {
            return false;
        }
    }

    public String createURL(Object ... provided_args) throws URLInvalidException {
        StringBuffer path = new StringBuffer();
        path.append(this.base_path);
        if (!this.base_path.startsWith("/") && !this.base_path.startsWith("\\")) {
            path.insert(0, "/");
        }
        if (provided_args.length > this.arguments.length) {
            throw new URLInvalidException("View " + this.name + " does not accept " + provided_args.length + " arguments");
        }
        if (provided_args.length > 0 && !this.base_path.endsWith("/") && !this.base_path.endsWith("\\")) {
            path.append("/");
        }
        int c = 0;
        while (c < provided_args.length) {
            String current_arg = provided_args[c].toString();
            if (!this.arguments[c].matcher(current_arg).matches()) {
                throw new URLInvalidException("Argument " + c + " does not match for view " + this.name);
            }
            path.append(this.escapeSlashes(current_arg));
            path.append("/");
            ++c;
        }
        return path.toString();
    }

    protected String normalizePath(String path) {
        if (path.startsWith("\\")) {
            path = path.substring(1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected String[] parseArgs(String path) throws URLInvalidException {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        String[] path_split = (path = this.normalizePath(path)).split(PATH_SPLIT_REGEX);
        if (this.base_path_split.length > path_split.length) {
            throw new URLInvalidException("Base path does not match");
        }
        int c = 0;
        while (c < this.base_path_split.length) {
            if (!this.base_path_split[c].equalsIgnoreCase(path_split[c])) {
                throw new URLInvalidException("Base path does not match");
            }
            ++c;
        }
        String[] args_final = new String[path_split.length - this.base_path_split.length];
        System.arraycopy(path_split, this.base_path_split.length, args_final, 0, args_final.length);
        this.checkNonBaseArgs(args_final);
        return args_final;
    }

    protected void checkNonBaseArgs(String[] args) throws URLInvalidException {
        if (args.length > this.arguments.length) {
            throw new URLInvalidException("Too many arguments provided to the view " + this.name);
        }
        int c = 0;
        while (c < args.length) {
            Matcher matcher = this.arguments[c].matcher(args[c]);
            if (!matcher.matches()) {
                throw new URLInvalidException("Argument " + c + " does not match for view " + args[c]);
            }
            ++c;
        }
        c = args.length;
        while (c < this.arguments.length) {
            if (!this.arguments[c].matcher("").matches()) {
                throw new URLInvalidException("Empty argument " + c + " is not allowed to be empty for view " + this.name);
            }
            ++c;
        }
    }

    protected String[] checkArgs(String[] args) throws URLInvalidException {
        if (args.length > this.arguments.length + this.base_path_split.length) {
            throw new URLInvalidException("Too many arguments provided for view " + this.name);
        }
        int c = 0;
        while (c < args.length) {
            Matcher matcher;
            if (c <= this.base_path_split.length ? !args[c].equalsIgnoreCase(this.base_path_split[c]) : c - this.base_path_split.length < this.arguments.length && !(matcher = this.arguments[c - this.base_path_split.length].matcher(args[c])).matches()) {
                throw new URLInvalidException("Argument " + c + " does not match for view " + args[c]);
            }
            ++c;
        }
        c = args.length;
        while (c < this.arguments.length) {
            if (!this.arguments[c].matcher("").matches()) {
                throw new URLInvalidException("Empty argument " + c + " is not allowed to be empty for view " + this.name);
            }
            ++c;
        }
        return args;
    }
}

