/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web;

import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.ClientAbortException;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardMiddlewareList;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewList;
import net.lukemurphey.nsia.web.middleware.Middleware;
import net.lukemurphey.nsia.web.views.Dialog;

public class WebConsoleServlet
extends HttpServlet {
    private static final long serialVersionUID = 8672076908249288190L;
    private static ViewList view_list = new ViewList();
    private SessionMessages session_messages = new SessionMessages();
    private Vector<Middleware> middleware = new Vector();
    public static final String SERVER_STRING = "ThreatFactor NSIA 1.0";

    public WebConsoleServlet() {
        view_list = StandardViewList.getViewList();
        this.middleware.addAll(StandardMiddlewareList.getMiddleware());
    }

    public void doRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("Server", SERVER_STRING);
            RequestContext context = null;
            Cookie[] cookies = request.getCookies();
            String sessionID = null;
            if (cookies != null) {
                Cookie[] cookieArray = cookies;
                int n = cookies.length;
                int n2 = 0;
                while (n2 < n) {
                    Cookie cookie = cookieArray[n2];
                    if (cookie.getName().equals("SessionID")) {
                        sessionID = cookie.getValue();
                        break;
                    }
                    ++n2;
                }
            }
            if (sessionID != null) {
                Application app = Application.getApplication();
                SessionManagement session_mgmt = new SessionManagement(app);
                SessionManagement.SessionInfo session_info = session_mgmt.getSessionInfo(sessionID);
                context = new RequestContext(session_info, this.session_messages);
            }
            for (Middleware m : this.middleware) {
                if (!m.process(request, response, context)) continue;
                return;
            }
            boolean handled = false;
            for (View view : view_list.getViews()) {
                try {
                    if (!view.process(request, response, context)) continue;
                    handled = true;
                    break;
                }
                catch (ClientAbortException e) {
                    Application.getApplication().logEvent(EventLogMessage.EventType.WEB_INFO_LOG, new EventLogField(EventLogField.FieldName.MESSAGE, "Connection closed"), new EventLogField(EventLogField.FieldName.URL, request.getServletPath()));
                    handled = true;
                }
                catch (ViewFailedException e) {
                    throw new ServletException("Exception thrown while generating view", (Throwable)e);
                }
            }
            if (!handled) {
                response.resetBuffer();
                response.setStatus(404);
                Application.getApplication().logEvent(EventLogMessage.EventType.WEB_INFO_LOG, new EventLogField(EventLogField.FieldName.MESSAGE, "Resource not found (404)"), new EventLogField(EventLogField.FieldName.URL, request.getServletPath()));
                Dialog.getDialog(response, context, Shortcuts.getMapWithBasics(context, request), "The resource you are looking for was not found", "Not Found (404)", Dialog.DialogType.WARNING, new Link("Return to the Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.WEB_ERROR, t);
            this.showServerErrorDialog(request, response, new RequestContext());
        }
    }

    protected void showServerErrorDialog(HttpServletRequest request, HttpServletResponse response, RequestContext context) {
        response.setStatus(500);
        try {
            Dialog.getDialog(response, context, Shortcuts.getMapWithBasics(context, request), "An internal application error has occurred", "Internal Error", Dialog.DialogType.CRITICAL);
        }
        catch (ViewFailedException e) {
            e.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }
}

