/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.forms;

import net.lukemurphey.nsia.web.forms.FieldValidator;
import net.lukemurphey.nsia.web.forms.FieldValidatorResponse;

public class Field {
    private String name;
    private FieldValidator validator;
    private boolean required = false;

    public Field(String name, FieldValidator validator, boolean required) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null");
        }
        if (validator == null) {
            throw new IllegalArgumentException("The validator cannot be null");
        }
        this.name = name;
        this.validator = validator;
        this.required = required;
    }

    public Field(String name, FieldValidator validator) {
        this(name, validator, false);
    }

    public Field(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public FieldValidator getValidator() {
        return this.validator;
    }

    public FieldValidatorResponse validate(String value) {
        if (this.validator != null) {
            return this.validator.validate(value);
        }
        return new FieldValidatorResponse(true);
    }

    public boolean isRequired() {
        return this.required;
    }
}

