/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.forms;

import net.lukemurphey.nsia.web.forms.FieldValidator;
import net.lukemurphey.nsia.web.forms.FieldValidatorResponse;

public class IntegerValidator
implements FieldValidator {
    private Integer minimum = null;
    private Integer maximum = null;

    public IntegerValidator() {
    }

    public IntegerValidator(int minimum, int maximum) {
        if (minimum > maximum) {
            throw new IllegalArgumentException("The minimum cannot be greater than the maximum");
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public IntegerValidator(int maximum) {
        this.maximum = maximum;
    }

    @Override
    public FieldValidatorResponse validate(String value) {
        int valueInt;
        try {
            valueInt = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return new FieldValidatorResponse(false, "Not a valid integer");
        }
        if (this.minimum != null && valueInt < this.minimum) {
            return new FieldValidatorResponse(false, "Cannot be less than " + this.minimum);
        }
        if (this.maximum != null && valueInt > this.maximum) {
            return new FieldValidatorResponse(false, "Cannot be greater than " + this.maximum);
        }
        return new FieldValidatorResponse(true);
    }
}

