/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.forms;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lukemurphey.nsia.web.forms.FieldValidator;
import net.lukemurphey.nsia.web.forms.FieldValidatorResponse;

public class PasswordValidator
implements FieldValidator {
    private static final Pattern HAS_UPPER = Pattern.compile("[A-Z]");
    private static final Pattern HAS_LOWER = Pattern.compile("[a-z]");
    private static final Pattern HAS_NUMBER = Pattern.compile("[0-9]");
    private static final Pattern HAS_SPECIAL = Pattern.compile("[^0-9A-Za-z]");
    private static final String REQUIREMENT_DESCRIPTION = "(must have lower and upper case characters, numbers and at least one special character)";

    @Override
    public FieldValidatorResponse validate(String value) {
        if (value == null || value.length() == 0) {
            return new FieldValidatorResponse(false, "Password must not be blank");
        }
        if (value.length() < 8) {
            return new FieldValidatorResponse(false, "Password must be at least 8 characters long");
        }
        Matcher upperMatcher = HAS_UPPER.matcher(value);
        Matcher lowerMatcher = HAS_LOWER.matcher(value);
        Matcher numberMatcher = HAS_NUMBER.matcher(value);
        Matcher specialMatcher = HAS_SPECIAL.matcher(value);
        if (!upperMatcher.find()) {
            return new FieldValidatorResponse(false, "Password does not have any upper case characters (must have lower and upper case characters, numbers and at least one special character)");
        }
        if (!lowerMatcher.find()) {
            return new FieldValidatorResponse(false, "Password does not have any lower case characters (must have lower and upper case characters, numbers and at least one special character)");
        }
        if (!numberMatcher.find()) {
            return new FieldValidatorResponse(false, "Password does not have any numbers (must have lower and upper case characters, numbers and at least one special character)");
        }
        if (!specialMatcher.find()) {
            return new FieldValidatorResponse(false, "Password does not have any special characters (must have lower and upper case characters, numbers and at least one special character)");
        }
        return new FieldValidatorResponse(true);
    }
}

