/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.middleware;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.middleware.Middleware;
import net.lukemurphey.nsia.web.middleware.MiddlewareException;
import net.lukemurphey.nsia.web.views.LoginBannerView;
import net.lukemurphey.nsia.web.views.MainDashboardView;

public class LoginBannerMiddleware
extends Middleware {
    @Override
    public boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context) throws MiddlewareException {
        String banner;
        if (request.getCookies() != null) {
            Cookie[] cookieArray = request.getCookies();
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if ("BannerCheck".equalsIgnoreCase(cookie.getName()) && "Accept".equalsIgnoreCase(cookie.getValue())) {
                    return false;
                }
                ++n2;
            }
        }
        try {
            banner = Application.getApplication().getApplicationConfiguration().getLoginBanner();
        }
        catch (NoDatabaseConnectionException e1) {
            throw new MiddlewareException(e1);
        }
        catch (SQLException e1) {
            throw new MiddlewareException(e1);
        }
        catch (InputValidationException e1) {
            throw new MiddlewareException(e1);
        }
        if (banner == null || banner.trim().length() == 0) {
            return false;
        }
        if ("Accept".equalsIgnoreCase(request.getParameter("BannerCheck"))) {
            block15: {
                Cookie cookie = new Cookie("BannerCheck", "Accept");
                cookie.setPath("/");
                response.addCookie(cookie);
                if (request.getParameter("ReturnTo") == null) break block15;
                response.sendRedirect(request.getParameter("ReturnTo"));
                return true;
            }
            try {
                response.sendRedirect(MainDashboardView.getURL());
                return true;
            }
            catch (IOException e) {
                throw new MiddlewareException(e);
            }
            catch (URLInvalidException e) {
                throw new MiddlewareException(e);
            }
        }
        LoginBannerView view = new LoginBannerView();
        try {
            return view.process(request, response, context);
        }
        catch (ViewFailedException e) {
            throw new MiddlewareException("Exception thrown while attempting to generate login banner view", e);
        }
    }
}

