/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.templates;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.views.Dialog;

public class DialogTemplateDirective
implements TemplateDirectiveModel {
    public static final String PARAM_MESSAGE = "message";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_TYPE = "type";

    public void execute(Environment env, Map params, TemplateModel[] model, TemplateDirectiveBody body) throws TemplateException, IOException {
        String dialog;
        Iterator paramIter = params.entrySet().iterator();
        String message = null;
        String title = null;
        String type_str = null;
        while (paramIter.hasNext()) {
            Map.Entry ent = paramIter.next();
            String paramName = (String)ent.getKey();
            TemplateModel paramValue = (TemplateModel)ent.getValue();
            if (paramName.equals(PARAM_MESSAGE)) {
                message = paramValue.toString();
                continue;
            }
            if (paramName.equals(PARAM_TITLE)) {
                title = paramValue.toString();
                continue;
            }
            if (!paramName.equals(PARAM_TYPE)) continue;
            type_str = paramValue.toString();
        }
        if (message == null) {
            throw new TemplateModelException("Dialog message was not provided");
        }
        if (title == null) {
            throw new TemplateModelException("Dialog title was not provided");
        }
        Dialog.DialogType type = Dialog.DialogType.INFORMATION;
        if (type_str == null) {
            type = Dialog.DialogType.INFORMATION;
        } else if (type_str.equalsIgnoreCase("Info") || type_str.equalsIgnoreCase("Information") || type_str.equalsIgnoreCase("Informational")) {
            type = Dialog.DialogType.INFORMATION;
        } else if (type_str.equalsIgnoreCase("Warn") || type_str.equalsIgnoreCase("Warning")) {
            type = Dialog.DialogType.WARNING;
        } else if (type_str.equalsIgnoreCase("Crit") || type_str.equalsIgnoreCase("Critical")) {
            type = Dialog.DialogType.CRITICAL;
        } else {
            throw new TemplateModelException("Dialog type is not valid");
        }
        try {
            dialog = Dialog.getDialog(message, title, type);
        }
        catch (ViewFailedException e) {
            throw new TemplateModelException("Dialog could not be generated", (Exception)e);
        }
        Writer out = env.getOut();
        out.write(dialog);
    }
}

