/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.templates;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class TruncateCharsDirective
implements TemplateDirectiveModel {
    public static final String PARAM_STRING_LENGTH = "length";
    public static final String PARAM_STRING_VALUE = "string";

    public void execute(Environment env, Map params, TemplateModel[] model, TemplateDirectiveBody body) throws TemplateException, IOException {
        Iterator paramIter = params.entrySet().iterator();
        int string_length = 32;
        while (paramIter.hasNext()) {
            Map.Entry ent = paramIter.next();
            String paramName = (String)ent.getKey();
            TemplateModel paramValue = (TemplateModel)ent.getValue();
            if (!paramName.equals(PARAM_STRING_LENGTH) || !(paramValue instanceof TemplateNumberModel)) continue;
            string_length = ((TemplateNumberModel)paramValue).getAsNumber().intValue();
        }
        if (string_length <= 0) {
            throw new TemplateModelException("String length must be greater than zero");
        }
        if (body != null) {
            body.render((Writer)new TruncateWriter(env.getOut(), string_length));
        }
    }

    private static class TruncateWriter
    extends Writer {
        private final Writer out;
        private int max_length;
        private boolean add_ellipses;
        private boolean reached_end = false;

        public TruncateWriter(Writer out, int max_length) {
            this.out = out;
            if (max_length > 3) {
                this.add_ellipses = true;
                this.max_length = max_length - 3;
            } else {
                this.max_length = max_length;
                this.add_ellipses = false;
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            boolean hit_end;
            char[] transformedCbuf;
            if (this.reached_end || off > this.max_length) {
                return;
            }
            if (off + len > this.max_length) {
                transformedCbuf = this.add_ellipses ? new char[this.max_length - off + 3] : new char[this.max_length - off];
                hit_end = true;
            } else {
                transformedCbuf = new char[len];
                hit_end = false;
            }
            if (hit_end && this.add_ellipses) {
                int i = 0;
                while (i < transformedCbuf.length - 3) {
                    transformedCbuf[i] = cbuf[i + off];
                    ++i;
                }
                transformedCbuf[transformedCbuf.length - 3] = 46;
                transformedCbuf[transformedCbuf.length - 2] = 46;
                transformedCbuf[transformedCbuf.length - 1] = 46;
                this.reached_end = true;
            } else {
                int i = 0;
                while (i < transformedCbuf.length) {
                    transformedCbuf[i] = cbuf[i + off];
                    ++i;
                }
            }
            this.out.write(transformedCbuf);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

