/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.AccessControl;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.ObjectPermissionDescriptor;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.forms.FieldError;
import net.lukemurphey.nsia.web.forms.FieldErrors;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.AccessControlView;

public class AccessControlEditView
extends View {
    private static final int VALUE_UNDEFINED = -1;
    private static final int VALUE_INVALID = -2;
    public static final String VIEW_NAME = "access_control_editor";

    public AccessControlEditView() {
        super("AccessControl", VIEW_NAME, Pattern.compile("[0-9]+"), Pattern.compile("New|Edit", 2), Pattern.compile("(User|Group)?", 2), Pattern.compile("[0-9]*"));
    }

    private AccessControlDescriptor.Action convertPermissionFromString(String permissionDescription) {
        if (permissionDescription == null) {
            return AccessControlDescriptor.Action.UNSPECIFIED;
        }
        if (permissionDescription.equalsIgnoreCase("Allow")) {
            return AccessControlDescriptor.Action.PERMIT;
        }
        if (permissionDescription.equalsIgnoreCase("Deny")) {
            return AccessControlDescriptor.Action.DENY;
        }
        return AccessControlDescriptor.Action.UNSPECIFIED;
    }

    private void processChange(AccessControl accessControl, ObjectPermissionDescriptor objectPermissionDesc, RequestContext context, HttpServletResponse response, long objectID) throws IOException, URLInvalidException, NoDatabaseConnectionException, SQLException {
        long id = accessControl.setPermissions(objectPermissionDesc);
        if (id > 0L) {
            Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET, new EventLogField(EventLogField.FieldName.OBJECT_ID, id));
        } else {
            Application.getApplication().logEvent(EventLogMessage.EventType.ACCESS_CONTROL_ENTRY_SET_FAILED);
        }
        context.addMessage("Access control list entry successfully updated", SessionMessages.MessageSeverity.SUCCESS);
        response.sendRedirect(AccessControlView.getURL(objectID));
    }

    private boolean processChanges(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data, long objectID) throws NoDatabaseConnectionException, SQLException, IOException, URLInvalidException {
        String subject = request.getParameter("Subject");
        if (subject == null) {
            FieldErrors errors = new FieldErrors();
            errors.put(new FieldError("Subject", "", "A user or group was not selected"));
            data.put("form_errors", errors);
            return false;
        }
        AccessControl accessControl = new AccessControl(Application.getApplication());
        if (request.getParameter("OperationRead") != null && request.getParameter("OperationModify") != null && request.getParameter("OperationControl") != null && request.getParameter("OperationExecute") != null && request.getParameter("OperationCreate") != null && request.getParameter("OperationDelete") != null) {
            block7: {
                AccessControlDescriptor.Action delete;
                AccessControlDescriptor.Action create;
                AccessControlDescriptor.Action execute;
                AccessControlDescriptor.Action control;
                AccessControlDescriptor.Action modify;
                AccessControlDescriptor.Action read;
                block6: {
                    read = this.convertPermissionFromString(request.getParameter("OperationRead"));
                    modify = this.convertPermissionFromString(request.getParameter("OperationModify"));
                    control = this.convertPermissionFromString(request.getParameter("OperationControl"));
                    execute = this.convertPermissionFromString(request.getParameter("OperationExecute"));
                    create = this.convertPermissionFromString(request.getParameter("OperationCreate"));
                    delete = this.convertPermissionFromString(request.getParameter("OperationDelete"));
                    try {
                        if (!subject.startsWith("group")) break block6;
                        int groupId = Integer.parseInt(subject.substring(5));
                        ObjectPermissionDescriptor objectPermissionDesc = new ObjectPermissionDescriptor(read, modify, create, execute, delete, control, AccessControlDescriptor.Subject.GROUP, groupId, objectID);
                        this.processChange(accessControl, objectPermissionDesc, context, response, objectID);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        FieldErrors errors = new FieldErrors();
                        errors.put(new FieldError("Subject", "", "A user or group was not selected"));
                        data.put("form_errors", errors);
                        return false;
                    }
                }
                if (!subject.startsWith("user")) break block7;
                int userId = Integer.parseInt(subject.substring(4));
                ObjectPermissionDescriptor objectPermissionDesc = new ObjectPermissionDescriptor(read, modify, create, execute, delete, control, AccessControlDescriptor.Subject.USER, userId, objectID);
                this.processChange(accessControl, objectPermissionDesc, context, response, objectID);
                return true;
            }
            context.addMessage("Access control list entry successfully updated", SessionMessages.MessageSeverity.SUCCESS);
            response.sendRedirect(AccessControlView.getURL(objectID));
            return true;
        }
        return false;
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        long objectId;
        AccessControl accessControl;
        block23: {
            block22: {
                block21: {
                    data.put("title", "Access Control");
                    accessControl = new AccessControl(Application.getApplication());
                    objectId = -1L;
                    if (args.length > 0) {
                        try {
                            objectId = Long.parseLong(args[0]);
                        }
                        catch (NumberFormatException e) {
                            objectId = -2L;
                        }
                    }
                    if (request.getParameter("Cancel") == null) break block21;
                    response.sendRedirect(AccessControlView.getURL(objectId));
                    return true;
                }
                if (Shortcuts.canControl(context.getSessionInfo(), objectId, "Edit access control list")) break block22;
                data.put("permission_denied_message", "You do not have permission to edit the access control list");
                TemplateLoader.renderToResponse("AccessControl.ftl", data, response);
                return true;
            }
            if (!"POST".equalsIgnoreCase(request.getMethod()) || !this.processChanges(request, response, context, args, data, objectId)) break block23;
            return true;
        }
        try {
            String subject = null;
            String subjectType = null;
            int groupId = -1;
            int userId = -1;
            ObjectPermissionDescriptor objectPermissionDescriptor = null;
            boolean isEditing = false;
            if (args.length >= 4) {
                subject = args[3];
                subjectType = args[2];
            }
            if (subject != null) {
                isEditing = true;
                try {
                    if (subjectType.equalsIgnoreCase("Group")) {
                        groupId = Integer.parseInt(subject);
                        objectPermissionDescriptor = accessControl.getGroupPermissions(groupId, objectId);
                        if (objectPermissionDescriptor == null) {
                            throw new ViewFailedException("Object permission descriptor is null for group ID " + groupId + " and object ID " + objectId);
                        }
                        data.put("permission", new AccessControlView.PermissionDescriptor(objectPermissionDescriptor));
                        data.put("subjectType", "Group");
                        data.put("subjectID", groupId);
                    } else if (subjectType.equalsIgnoreCase("User")) {
                        userId = Integer.parseInt(subject);
                        objectPermissionDescriptor = accessControl.getUserPermissions(userId, objectId, false);
                        if (objectPermissionDescriptor == null) {
                            throw new ViewFailedException("Object permission descriptor is null for user ID " + userId + " and object ID " + objectId);
                        }
                        data.put("permission", new AccessControlView.PermissionDescriptor(objectPermissionDescriptor));
                        data.put("subjectType", "User");
                        data.put("subjectID", userId);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            GroupManagement groupMgmt = new GroupManagement(Application.getApplication());
            data.put("groups", groupMgmt.getGroupDescriptors());
            UserManagement userMgmt = new UserManagement(Application.getApplication());
            data.put("users", userMgmt.getUserDescriptors());
            data.put("isEditing", isEditing);
            data.put("objectID", objectId);
            data.put("GROUP", (Object)AccessControlDescriptor.Subject.GROUP);
            data.put("USER", (Object)AccessControlDescriptor.Subject.USER);
            data.put("DENY", (Object)AccessControlDescriptor.Action.DENY);
            data.put("PERMIT", (Object)AccessControlDescriptor.Action.PERMIT);
            data.put("UNSPECIFIED", (Object)AccessControlDescriptor.Action.UNSPECIFIED);
            data.put("VALUE_UNDEFINED", -1);
            data.put("VALUE_INVALID", -2);
            data.put("userID", userId);
            data.put("groupID", groupId);
            ACLDescriptor aclDesc = new ACLDescriptor(objectPermissionDescriptor, request);
            data.put("read", (Object)aclDesc.read);
            data.put("create", (Object)aclDesc.create);
            data.put("delete", (Object)aclDesc.delete);
            data.put("execute", (Object)aclDesc.execute);
            data.put("write", (Object)aclDesc.write);
            data.put("control", (Object)aclDesc.control);
            TemplateLoader.renderToResponse("AccessControlEdit.ftl", data, response);
            return true;
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NotFoundException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
    }

    private static class ACLDescriptor {
        public AccessControlDescriptor.Action read = AccessControlDescriptor.Action.UNSPECIFIED;
        public AccessControlDescriptor.Action write = AccessControlDescriptor.Action.UNSPECIFIED;
        public AccessControlDescriptor.Action delete = AccessControlDescriptor.Action.UNSPECIFIED;
        public AccessControlDescriptor.Action control = AccessControlDescriptor.Action.UNSPECIFIED;
        public AccessControlDescriptor.Action execute = AccessControlDescriptor.Action.UNSPECIFIED;
        public AccessControlDescriptor.Action create = AccessControlDescriptor.Action.UNSPECIFIED;

        public ACLDescriptor(ObjectPermissionDescriptor objectPermissionDescriptor, HttpServletRequest request) {
            if (objectPermissionDescriptor != null) {
                this.read = objectPermissionDescriptor.getReadPermission();
                this.write = objectPermissionDescriptor.getModifyPermission();
                this.delete = objectPermissionDescriptor.getDeletePermission();
                this.control = objectPermissionDescriptor.getControlPermission();
                this.create = objectPermissionDescriptor.getCreatePermission();
                this.execute = objectPermissionDescriptor.getExecutePermission();
            }
            this.read = this.getACL(this.read, request.getParameter("OperationRead"));
            this.write = this.getACL(this.write, request.getParameter("OperationWrite"));
            this.delete = this.getACL(this.delete, request.getParameter("OperationDelete"));
            this.control = this.getACL(this.control, request.getParameter("OperationControl"));
            this.create = this.getACL(this.create, request.getParameter("OperationCreate"));
            this.execute = this.getACL(this.execute, request.getParameter("OperationExecute"));
        }

        private AccessControlDescriptor.Action getACL(AccessControlDescriptor.Action aclValue, String argument) {
            AccessControlDescriptor.Action aclType = aclValue;
            if (argument != null) {
                if (argument.equals("Allow")) {
                    aclType = AccessControlDescriptor.Action.PERMIT;
                } else if (argument.equals("Deny")) {
                    aclType = AccessControlDescriptor.Action.DENY;
                } else if (argument.equals("Undefined")) {
                    aclType = AccessControlDescriptor.Action.UNSPECIFIED;
                }
            }
            return aclType;
        }
    }
}

