/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.AccessControl;
import net.lukemurphey.nsia.AccessControlDescriptor;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.ObjectPermissionDescriptor;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class AccessControlView
extends View {
    private static final int VALUE_UNDEFINED = -1;
    private static final int VALUE_INVALID = -2;
    public static final String VIEW_NAME = "access_control";

    public AccessControlView() {
        super("AccessControl", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    public static String getURL(int objectID) throws URLInvalidException {
        AccessControlView view = new AccessControlView();
        return view.createURL(objectID);
    }

    public static String getURL(long objectID) throws URLInvalidException {
        AccessControlView view = new AccessControlView();
        return view.createURL(objectID);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        boolean isEditing;
        long objectId;
        AccessControl accessControl;
        block13: {
            data.put("title", "Access Control");
            accessControl = new AccessControl(Application.getApplication());
            objectId = -1L;
            if (args.length > 0) {
                try {
                    objectId = Long.parseLong(args[0]);
                }
                catch (NumberFormatException e) {
                    objectId = -2L;
                }
            }
            String subject = request.getParameter("Subject");
            isEditing = false;
            if (subject != null) {
                isEditing = true;
            }
            if (Shortcuts.canControl(context.getSessionInfo(), objectId, "View access control list")) break block13;
            data.put("permission_denied_message", "You do not have permission to view the access control list");
            TemplateLoader.renderToResponse("AccessControl.ftl", data, response);
            return true;
        }
        try {
            if (!isEditing) {
                ObjectPermissionDescriptor[] descriptors = accessControl.getAllAclEntries(objectId);
                PermissionDescriptor[] subject_descriptors = new PermissionDescriptor[descriptors.length];
                int c = 0;
                while (c < descriptors.length) {
                    subject_descriptors[c] = new PermissionDescriptor(descriptors[c]);
                    ++c;
                }
                data.put("permissions", subject_descriptors);
            }
            data.put("objectID", objectId);
            data.put("GROUP", (Object)AccessControlDescriptor.Subject.GROUP);
            data.put("USER", (Object)AccessControlDescriptor.Subject.USER);
            data.put("DENY", (Object)AccessControlDescriptor.Action.DENY);
            data.put("PERMIT", (Object)AccessControlDescriptor.Action.PERMIT);
            data.put("UNSPECIFIED", (Object)AccessControlDescriptor.Action.UNSPECIFIED);
            TemplateLoader.renderToResponse("AccessControl.ftl", data, response);
            return true;
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NotFoundException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
    }

    public static class PermissionDescriptor {
        private ObjectPermissionDescriptor objectDescriptor = null;
        private Object subject;

        public PermissionDescriptor(ObjectPermissionDescriptor obj) throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
            if (obj == null) {
                throw new IllegalArgumentException("ObjectPermissionDescriptor cannot be null");
            }
            this.objectDescriptor = obj;
            this.subject = this.populateSubject();
        }

        public int getSubjectID() {
            return this.objectDescriptor.getSubjectId();
        }

        public long getObjectID() {
            return this.objectDescriptor.getObjectId();
        }

        public AccessControlDescriptor.Subject getSubjectType() {
            return this.objectDescriptor.getSubjectType();
        }

        public boolean isGroup() {
            return this.objectDescriptor.isGroup();
        }

        public boolean isUser() {
            return this.objectDescriptor.isUser();
        }

        public AccessControlDescriptor.Action getControlPermission() {
            return this.objectDescriptor.getControlPermission();
        }

        public AccessControlDescriptor.Action getCreatePermission() {
            return this.objectDescriptor.getCreatePermission();
        }

        public AccessControlDescriptor.Action getDeletePermission() {
            return this.objectDescriptor.getDeletePermission();
        }

        public AccessControlDescriptor.Action getExecutePermission() {
            return this.objectDescriptor.getExecutePermission();
        }

        public AccessControlDescriptor.Action getModifyPermission() {
            return this.objectDescriptor.getModifyPermission();
        }

        public AccessControlDescriptor.Action getReadPermission() {
            return this.objectDescriptor.getReadPermission();
        }

        public Object getSubject() {
            return this.subject;
        }

        private Object populateSubject() throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException {
            int subjectID = this.objectDescriptor.getSubjectId();
            if (this.objectDescriptor.isGroup()) {
                GroupManagement groupMgmt = new GroupManagement(Application.getApplication());
                return groupMgmt.getGroupDescriptor(subjectID);
            }
            UserManagement userMgmt = new UserManagement(Application.getApplication());
            return userMgmt.getUserDescriptor(subjectID);
        }
    }
}

