/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.eventlog.EventLog;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogHook;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.eventlog.SiteGroupStatusEventLogHook;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.MainDashboardView;
import net.lukemurphey.nsia.web.views.SiteGroupView;

public class ActionsListView
extends View {
    public static final String VIEW_NAME = "sitegroup_actions";

    public ActionsListView() {
        super("Actions/SiteGroup", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    public static String getURL(SiteGroupManagement.SiteGroupDescriptor siteGroup) throws URLInvalidException {
        ActionsListView actionsList = new ActionsListView();
        return actionsList.createURL(siteGroup.getGroupId());
    }

    public static String getURL(long siteGroupID) throws URLInvalidException {
        ActionsListView actionsList = new ActionsListView();
        return actionsList.createURL(siteGroupID);
    }

    private long[] getHooks(HttpServletRequest request) {
        Vector<Long> hookIDs = new Vector<Long>();
        String[] stringArray = request.getParameterValues("ActionID");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            hookIDs.add(Long.valueOf(param));
            ++n2;
        }
        long[] a = new long[hookIDs.size()];
        int c = 0;
        while (c < a.length) {
            a[c] = (Long)hookIDs.get(c);
            ++c;
        }
        return a;
    }

    private int deleteHooks(RequestContext context, long[] hooks, SiteGroupManagement.SiteGroupDescriptor siteGroup) throws SQLException, NoDatabaseConnectionException {
        int hooksDeleted = 0;
        EventLog eventLog = Application.getApplication().getEventLog();
        long[] lArray = hooks;
        int n = hooks.length;
        int n2 = 0;
        while (n2 < n) {
            SiteGroupStatusEventLogHook siteGroupHook;
            long hookID = lArray[n2];
            EventLogHook hook = eventLog.getHook(hookID);
            if (hook instanceof SiteGroupStatusEventLogHook && (siteGroupHook = (SiteGroupStatusEventLogHook)hook).getSiteGroupID() == siteGroup.getGroupId()) {
                EventLogHook.delete(hookID);
                eventLog.deleteHook(hookID);
                Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.RESPONSE_ACTION_DELETED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.RESPONSE_ACTION_ID, hook.getEventLogHookID()), new EventLogField(EventLogField.FieldName.GROUP_ID, siteGroup.getGroupId()), new EventLogField(EventLogField.FieldName.GROUP_NAME, siteGroup.getGroupName())));
                ++hooksDeleted;
            }
            ++n2;
        }
        context.addMessage(String.valueOf(hooksDeleted) + " actions have been deleted", SessionMessages.MessageSeverity.SUCCESS);
        return hooksDeleted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        try {
            SiteGroupManagement.SiteGroupDescriptor siteGroup = null;
            try {
                int siteGroupID = Integer.valueOf(args[0]);
                SiteGroupManagement siteGroupMgmt = new SiteGroupManagement(Application.getApplication());
                siteGroup = siteGroupMgmt.getGroupDescriptor(siteGroupID);
            }
            catch (NotFoundException e) {
                Dialog.getDialog(response, context, data, "The site-group associated with the given rule could not be found", "Site-group Not Found", Dialog.DialogType.INFORMATION);
                return true;
            }
            data.put("menu", Menu.getSiteGroupMenu(context, siteGroup));
            Vector<Link> breadcrumbs = new Vector<Link>();
            breadcrumbs.add(new Link("Main Dashboard", MainDashboardView.getURL()));
            breadcrumbs.add(new Link("Site-group: " + siteGroup.getGroupName(), SiteGroupView.getURL(siteGroup.getGroupId())));
            breadcrumbs.add(new Link("Actions", this.createURL(siteGroup.getGroupId())));
            data.put("breadcrumbs", breadcrumbs);
            data.put("title", "Incident Response Actions");
            Shortcuts.addDashboardHeaders(request, response, data);
            try {
                if (!Shortcuts.canRead(context.getSessionInfo(), siteGroup.getObjectId(), "View incident response actions site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                    data.put("permission_denied_message", "You do not permission to view this site group.");
                    data.put("permission_denied_link", new Link("View Site Group", SiteGroupView.getURL(siteGroup)));
                    TemplateLoader.renderToResponse("PermissionDenied.ftl", data, response);
                    return true;
                }
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
            data.put("siteGroup", siteGroup);
            if ("Delete".equalsIgnoreCase(request.getParameter("Action"))) {
                try {
                    if (!Shortcuts.canModify(context.getSessionInfo(), siteGroup.getObjectId(), "Edit incident response actions for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                        data.put("permission_denied_message", "You do not permission to edit this site-group.");
                        data.put("permission_denied_link", new Link("View Site Group", SiteGroupView.getURL(siteGroup)));
                        TemplateLoader.renderToResponse("PermissionDenied.ftl", data, response);
                        return true;
                    }
                }
                catch (GeneralizedException e) {
                    throw new ViewFailedException(e);
                }
                this.deleteHooks(context, this.getHooks(request), siteGroup);
            }
            SiteGroupStatusEventLogHook[] hooks = SiteGroupStatusEventLogHook.getSiteGroupEventLogHooks(Application.getApplication(), siteGroup.getGroupId());
            data.put("actions", hooks);
            TemplateLoader.renderToResponse("ResponseActionList.ftl", data, response);
            return true;
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
    }
}

