/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionArchiveException;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.DefinitionsView;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class DefinitionsImportView
extends View {
    public static final String VIEW_NAME = "definitions_import";

    public DefinitionsImportView() {
        super("Definitions/Import", VIEW_NAME, new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        DefinitionsImportView view = new DefinitionsImportView();
        return view.createURL(new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        boolean isMultipart;
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Import definitions")) {
                context.addMessage("You do not have permission to import definitions", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(DefinitionsView.getURL());
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        if (request.getMethod().equalsIgnoreCase("POST") && (isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request))) {
            ServletFileUpload upload = new ServletFileUpload();
            try {
                FileItemIterator iter = upload.getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    if (!item.getFieldName().equalsIgnoreCase("DefinitionsFile")) continue;
                    InputStream stream = item.openStream();
                    String xmlString = DefinitionsImportView.getString(stream, 16000000);
                    if (xmlString != null && xmlString.length() != 0) {
                        DefinitionArchive archive = DefinitionArchive.getArchive();
                        archive.updateDefinitions(xmlString, false);
                        Application.getApplication().logEvent(EventLogMessage.EventType.DEFINITION_SET_UPDATED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getSessionInfo().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getSessionInfo().getUserId()), new EventLogField(EventLogField.FieldName.IMPORT_SOURCE, "Local file"));
                        context.addMessage("Definitions successfully imported", SessionMessages.MessageSeverity.SUCCESS);
                        response.sendRedirect(StandardViewList.getURL("definitions_list", new Object[0]));
                        return true;
                    }
                    context.addMessage("Definition file is not valid (is empty)", SessionMessages.MessageSeverity.WARNING);
                }
            }
            catch (FileUploadException e) {
                context.addMessage("Definition file upload failed", SessionMessages.MessageSeverity.WARNING);
            }
            catch (DefinitionSetLoadException e) {
                context.addMessage("Definition file is not valid", SessionMessages.MessageSeverity.WARNING);
            }
            catch (DefinitionArchiveException e) {
                context.addMessage("Definition file is not valid", SessionMessages.MessageSeverity.WARNING);
            }
            catch (SQLException e) {
                throw new ViewFailedException(e);
            }
            catch (NoDatabaseConnectionException e) {
                throw new ViewFailedException(e);
            }
            catch (InputValidationException e) {
                throw new ViewFailedException(e);
            }
        }
        Vector<Link> breadcrumbs = new Vector<Link>();
        breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
        breadcrumbs.add(new Link("Definitions", StandardViewList.getURL("definitions_list", new Object[0])));
        breadcrumbs.add(new Link("Import Definitions", this.createURL(new Object[0])));
        data.put("breadcrumbs", breadcrumbs);
        data.put("menu", Menu.getDefinitionMenu(context));
        Shortcuts.addDashboardHeaders(request, response, data);
        data.put("title", "Import Definitions");
        TemplateLoader.renderToResponse("DefinitionsImport.ftl", data, response);
        return true;
    }

    private static String getString(InputStream in, int bytesLimit) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            bos.write(buf, 0, len);
        }
        String fileData = new String(bos.toByteArray());
        return fileData;
    }
}

