/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.rest.RESTRequestFailedException;
import net.lukemurphey.nsia.scan.Definition;
import net.lukemurphey.nsia.scan.DefinitionArchive;
import net.lukemurphey.nsia.scan.DefinitionSet;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import org.apache.commons.lang.StringUtils;

public class DefinitionsView
extends View {
    public static final int DEFINITIONS_PER_PAGE = 25;
    public static final String VIEW_NAME = "definitions_list";

    public DefinitionsView() {
        super("Definitions", VIEW_NAME, new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        DefinitionsView view = new DefinitionsView();
        return view.createURL(new Object[0]);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        try {
            int c;
            int start;
            data.put("title", "Definitions");
            Vector<Link> breadcrumbs = new Vector<Link>();
            breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
            breadcrumbs.add(new Link("Definitions", this.createURL(new Object[0])));
            data.put("breadcrumbs", breadcrumbs);
            data.put("menu", Menu.getDefinitionMenu(context));
            Shortcuts.addDashboardHeaders(request, response, data);
            try {
                if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.View", "View definitions")) {
                    Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view the definitions");
                    return true;
                }
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
            boolean endRequested = false;
            int page = 1;
            if (request.getParameter("N") != null && request.getParameter("N").equalsIgnoreCase("End")) {
                endRequested = true;
            } else if (request.getParameter("N") != null) {
                try {
                    page = Integer.parseInt(request.getParameter("N"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (page < 1) {
                    page = 1;
                }
            }
            String filter = request.getParameter("Filter");
            boolean notFilter = request.getParameter("Not") != null;
            Vector<Definition> definitionsList = new Vector<Definition>();
            DefinitionArchive archive = DefinitionArchive.getArchive();
            int definitionsMatching = 0;
            Definition[] definitions = archive.getDefinitionsSorted();
            if (definitions == null) {
                definitions = new Definition[]{};
            }
            if (filter == null || filter.isEmpty()) {
                if (endRequested) {
                    page = (int)Math.ceil((double)definitions.length / 25.0);
                }
                c = start = 25 * (page - 1);
                while (definitionsMatching < 25 && c < definitions.length) {
                    definitionsList.add(definitions[c]);
                    ++definitionsMatching;
                    ++c;
                }
                definitionsMatching = definitions.length;
            } else {
                int end;
                if (endRequested) {
                    c = 0;
                    while (c < definitions.length) {
                        if (!notFilter && StringUtils.containsIgnoreCase((String)definitions[c].getFullName(), (String)filter) || notFilter && !StringUtils.containsIgnoreCase((String)definitions[c].getFullName(), (String)filter)) {
                            ++definitionsMatching;
                        }
                        ++c;
                    }
                    start = definitionsMatching - definitionsMatching % 25;
                    end = start + 25;
                    definitionsMatching = 0;
                } else {
                    start = 25 * (page - 1);
                    end = start + 25;
                }
                c = 0;
                while (c < definitions.length) {
                    if ((!notFilter && StringUtils.containsIgnoreCase((String)definitions[c].getFullName(), (String)filter) || notFilter && !StringUtils.containsIgnoreCase((String)definitions[c].getFullName(), (String)filter)) && ++definitionsMatching >= start && definitionsMatching <= end) {
                        definitionsList.add(definitions[c]);
                    }
                    ++c;
                }
            }
            DefinitionSet definitionSet = archive.getDefinitionSet();
            data.put("updated", definitionSet.getDefinitionSetDate());
            data.put("newer_definitions_available", archive.isNewDefinitionSetAvailable());
            try {
                data.put("latest_definitions", DefinitionArchive.getLatestAvailableDefinitionSetID());
            }
            catch (RESTRequestFailedException rESTRequestFailedException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            data.put("definition_set_version", definitionSet.getVersionID());
            data.put("filter", filter);
            data.put("not_filter", notFilter);
            data.put("definitions", definitionsList);
            int totalPages = (int)Math.ceil((double)definitionsMatching / 25.0);
            int currentPage = page - 1;
            int startPage = Math.max(currentPage - 3, 1);
            if (totalPages > 10 && startPage + 9 > totalPages) {
                startPage = Math.max(totalPages - 9, 1);
            }
            data.put("total_entries", 12);
            data.put("entries_per_page", 25);
            data.put("current_page", 12);
            data.put("total_entries", definitionsMatching);
            data.put("start_page", startPage);
            data.put("total_pages", totalPages);
            Vector<Integer> pageNums = new Vector<Integer>();
            int c2 = startPage;
            while (c2 < startPage + 10 && c2 <= totalPages) {
                pageNums.add(c2);
                ++c2;
            }
            data.put("page_numbers", pageNums);
            if (startPage + 10 < totalPages) {
                data.put("needs_end_marker", true);
            }
            TemplateLoader.renderToResponse("DefinitionsList.ftl", data, response);
            return true;
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (DefinitionSetLoadException e) {
            throw new ViewFailedException(e);
        }
    }
}

