/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DefinitionPolicyDescriptor;
import net.lukemurphey.nsia.scan.DefinitionPolicyManagement;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.ExceptionListView;

public class ExceptionDeleteView
extends View {
    public static final String VIEW_NAME = "exception_delete";

    public ExceptionDeleteView() {
        super("Exception/Delete", VIEW_NAME, Pattern.compile("[0-9]*"));
    }

    public static String getURL(int exceptionID) throws URLInvalidException {
        ExceptionDeleteView view = new ExceptionDeleteView();
        return view.createURL(exceptionID);
    }

    private int deleteExceptions(RequestContext context, Vector<Integer> exceptions) throws SQLException, NoDatabaseConnectionException, NotFoundException, MalformedURLException, ViewFailedException, InsufficientPermissionException, GeneralizedException, NoSessionException {
        int exceptionsDeleted = 0;
        DefinitionPolicyManagement policyManagement = new DefinitionPolicyManagement(Application.getApplication());
        SiteGroupManagement siteGroupMgmt = new SiteGroupManagement(Application.getApplication());
        SiteGroupManagement.SiteGroupDescriptor siteGroup = null;
        for (int exceptionID : exceptions) {
            DefinitionPolicyDescriptor policy = policyManagement.getPolicy(exceptionID);
            int siteGroupID = policy.getSiteGroupID();
            if (siteGroupID <= 0) {
                int ruleID = policy.getPolicyRuleID();
                siteGroupID = ScanRule.getSiteGroupForRule(ruleID);
            }
            if (siteGroupID <= 0) {
                throw new ViewFailedException("Could not find the site-group associated with the definition policy " + exceptionID);
            }
            try {
                if (siteGroup == null || siteGroup.getGroupId() != siteGroupID) {
                    siteGroup = siteGroupMgmt.getGroupDescriptor(siteGroupID);
                }
                Shortcuts.checkDelete(context.getSessionInfo(), siteGroup.getObjectId(), "Delete definition policy ID " + exceptionID + " from site-group ID " + siteGroup.getGroupId() + "( " + siteGroup.getGroupName() + ")");
            }
            catch (InputValidationException e) {
                throw new ViewFailedException(e);
            }
            policyManagement.deletePolicy(exceptionID);
            ++exceptionsDeleted;
        }
        context.addMessage(String.valueOf(exceptionsDeleted) + " exceptions have been deleted", SessionMessages.MessageSeverity.SUCCESS);
        Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.RULE_EXCEPTION_DELETED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.GROUP_ID, siteGroup.getGroupId()), new EventLogField(EventLogField.FieldName.GROUP_NAME, siteGroup.getGroupName())));
        return exceptionsDeleted;
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        int ruleID = Integer.valueOf(args[0]);
        Vector<Integer> exceptionsToDelete = new Vector<Integer>();
        String[] identifiers = request.getParameterValues("ExceptionID");
        if (identifiers == null) {
            context.addMessage("Select the entries to delete", SessionMessages.MessageSeverity.WARNING);
            response.sendRedirect(ExceptionListView.getURL(ruleID));
            return false;
        }
        String[] stringArray = identifiers;
        int n = identifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String stringID = stringArray[n2];
            try {
                exceptionsToDelete.add(new Integer(stringID));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        try {
            this.deleteExceptions(context, exceptionsToDelete);
        }
        catch (NotFoundException e) {
            Dialog.getDialog(response, context, data, "Exception could not be deleted because it could not be found", "Exception Not Found", Dialog.DialogType.WARNING);
            return true;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (InsufficientPermissionException e) {
            context.addMessage("You do not have permission to delete exceptions for this site-group", SessionMessages.MessageSeverity.WARNING);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        catch (NoSessionException e) {
            throw new ViewFailedException(e);
        }
        response.sendRedirect(ExceptionListView.getURL(ruleID));
        return true;
    }
}

