/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.forms.Field;
import net.lukemurphey.nsia.web.forms.FieldErrors;
import net.lukemurphey.nsia.web.forms.Form;
import net.lukemurphey.nsia.web.forms.PatternValidator;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.GroupListView;
import net.lukemurphey.nsia.web.views.GroupView;

public class GroupEditView
extends View {
    public static final String VIEW_NAME = "group_editor";

    public GroupEditView() {
        super("Group", VIEW_NAME, Pattern.compile("(New)|(Edit)", 2), Pattern.compile("[0-9]*"));
    }

    public static String getURL() throws URLInvalidException {
        GroupEditView view = new GroupEditView();
        return view.createURL("New");
    }

    public static String getURL(GroupManagement.GroupDescriptor group) throws URLInvalidException {
        GroupEditView view = new GroupEditView();
        return view.createURL("Edit", group.getGroupId());
    }

    public static String getURL(int groupID) throws URLInvalidException {
        GroupEditView view = new GroupEditView();
        return view.createURL("Edit", groupID);
    }

    private Form getGroupEditForm() {
        Form form = new Form();
        form.addField(new Field("Name", new PatternValidator(Pattern.compile("[-A-Z0-9a-z_ .]{1,32}", 2), "Group name is not valid")));
        form.addField(new Field("Description"));
        return form;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean performActions(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data, GroupManagement.GroupDescriptor group) throws ViewFailedException, IOException, URLInvalidException, ViewNotFoundException {
        try {
            GroupManagement groupManager = new GroupManagement(Application.getApplication());
            if (!"POST".equalsIgnoreCase(request.getMethod())) return false;
            Form form = this.getGroupEditForm();
            FieldErrors errors = form.validate(request);
            if (errors.size() > 0) {
                data.put("form_errors", errors);
                return false;
            }
            String name = request.getParameter("Name");
            String description = request.getParameter("Description");
            try {
                if (group == null) {
                    int groupID = groupManager.addGroup(name, description);
                    context.addMessage("Group created successfully", SessionMessages.MessageSeverity.SUCCESS);
                    group = groupManager.getGroupDescriptor(groupID);
                    response.sendRedirect(GroupView.getURL(group));
                    return true;
                }
                if (groupManager.updateGroupInfo(group.getGroupId(), name, description)) {
                    Application.getApplication().logEvent(EventLogMessage.EventType.GROUP_MODIFIED, new EventLogField(EventLogField.FieldName.GROUP_ID, group.getGroupId()), new EventLogField(EventLogField.FieldName.GROUP_NAME, group.getGroupName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
                    context.addMessage("Group updated successfully", SessionMessages.MessageSeverity.SUCCESS);
                    response.sendRedirect(GroupView.getURL(group));
                    return true;
                }
                Application.getApplication().logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.GROUP_ID, group.getGroupId()), new EventLogField(EventLogField.FieldName.GROUP_NAME, group.getGroupName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
                context.addMessage("Group could not be updated", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(GroupEditView.getURL(group));
                return true;
            }
            catch (InputValidationException e) {
                throw new ViewFailedException(e);
            }
        }
        catch (SQLException e2) {
            throw new ViewFailedException(e2);
        }
        catch (NoDatabaseConnectionException e3) {
            throw new ViewFailedException(e3);
        }
        catch (NotFoundException e4) {
            throw new ViewFailedException(e4);
        }
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        GroupManagement.GroupDescriptor group;
        block16: {
            group = null;
            if (args.length >= 2) {
                int groupID;
                try {
                    groupID = Integer.valueOf(args[1]);
                }
                catch (NumberFormatException e) {
                    Dialog.getDialog(response, context, data, "The Group ID provided is not valid", "Group ID Invalid", Dialog.DialogType.WARNING);
                    return true;
                }
                GroupManagement groupMgmt = new GroupManagement(Application.getApplication());
                try {
                    group = groupMgmt.getGroupDescriptor(groupID);
                }
                catch (NotFoundException e) {
                    Dialog.getDialog(response, context, data, "No group was found with the given ID", "Group Not Found", Dialog.DialogType.WARNING);
                    return true;
                }
                catch (SQLException e) {
                    throw new ViewFailedException(e);
                }
                catch (NoDatabaseConnectionException e) {
                    throw new ViewFailedException(e);
                }
                catch (InputValidationException e) {
                    throw new ViewFailedException(e);
                }
                if (group == null) {
                    Dialog.getDialog(response, context, data, "No group was found with the given ID", "Group Not Found", Dialog.DialogType.WARNING);
                    return true;
                }
                data.put("group", group);
            }
            data.put("menu", Menu.getGroupMenuItems(context, group));
            Vector<Link> breadcrumbs = new Vector<Link>();
            breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
            breadcrumbs.add(new Link("Group Management", GroupListView.getURL()));
            if (group != null) {
                breadcrumbs.add(new Link("Group: " + group.getGroupName(), GroupView.getURL(group)));
                breadcrumbs.add(new Link("Edit", GroupEditView.getURL(group)));
                data.put("title", "Group: " + group.getGroupName());
            } else {
                breadcrumbs.add(new Link("New Group", this.createURL("New")));
                data.put("title", "New Group");
            }
            data.put("breadcrumbs", breadcrumbs);
            Shortcuts.addDashboardHeaders(request, response, data);
            try {
                if (group != null || Shortcuts.hasRight(context.getSessionInfo(), "Groups.Add", "Create user group")) break block16;
                Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to create groups");
                return true;
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
        }
        if (!Shortcuts.hasRight(context.getSessionInfo(), "Groups.Edit", "Edit user groups")) {
            Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to edit groups");
            return true;
        }
        if (this.performActions(request, response, context, args, data, group)) {
            return true;
        }
        TemplateLoader.renderToResponse("GroupEdit.ftl", data, response);
        return true;
    }
}

