/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.ApplicationConfiguration;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.LicenseDescriptor;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class LicenseView
extends View {
    public static final String VIEW_NAME = "license";

    public LicenseView() {
        super("License", VIEW_NAME, new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        LicenseView view = new LicenseView();
        return view.createURL(new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        try {
            String licenseKey;
            Vector<Link> breadcrumbs = new Vector<Link>();
            breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
            breadcrumbs.add(new Link("System Status", StandardViewList.getURL("system_status", new Object[0])));
            breadcrumbs.add(new Link("License Management", this.createURL(new Object[0])));
            data.put("breadcrumbs", breadcrumbs);
            data.put("menu", Menu.getSystemMenu(context));
            data.put("title", "License");
            Shortcuts.addDashboardHeaders(request, response, data);
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.View", "View license")) {
                Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view the license");
                return true;
            }
            ApplicationConfiguration config = Application.getApplication().getApplicationConfiguration();
            LicenseDescriptor license = null;
            license = config.getLicense();
            if (request.getParameter("LicenseKey") != null) {
                licenseKey = request.getParameter("LicenseKey");
                if ("POST".equalsIgnoreCase(request.getMethod()) && licenseKey != null) {
                    if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Configuration.Edit", "Update license")) {
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to update the license");
                        return true;
                    }
                    config.setLicenseKey(licenseKey);
                    Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.SYSTEM_CONFIGURATION_CHANGED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.PARAMETER, "license_key"), new EventLogField(EventLogField.FieldName.PARAMETER_VALUE, licenseKey)));
                    license = config.getLicense(false);
                }
            } else {
                licenseKey = license == null ? "" : (license.getKey() != null ? license.getKey() : "");
            }
            data.put("ACTIVE", (Object)LicenseDescriptor.LicenseStatus.ACTIVE);
            data.put("DEMO", (Object)LicenseDescriptor.LicenseStatus.DEMO);
            data.put("DISABLED", (Object)LicenseDescriptor.LicenseStatus.DISABLED);
            data.put("EXPIRED", (Object)LicenseDescriptor.LicenseStatus.EXPIRED);
            data.put("ILLEGAL", (Object)LicenseDescriptor.LicenseStatus.ILLEGAL);
            data.put("UNLICENSED", (Object)LicenseDescriptor.LicenseStatus.UNLICENSED);
            data.put("UNVALIDATED", (Object)LicenseDescriptor.LicenseStatus.UNVALIDATED);
            data.put("license_key", licenseKey);
            data.put(VIEW_NAME, license);
            data.put("license_check_completed", config.licenseKeyCheckCompleted());
            TemplateLoader.renderToResponse("LicenseView.ftl", data, response);
            return true;
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
    }
}

