/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.Authentication;
import net.lukemurphey.nsia.ClientData;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.LocalPasswordAuthentication;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.PasswordAuthenticationValidator;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.SessionStatus;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.DashboardPreLoginPanel;
import net.lukemurphey.nsia.web.views.MainDashboardView;

public class LoginView
extends View {
    public LoginView() {
        super("Login", "login", new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        LoginView view = new LoginView();
        return view.createURL(new Object[0]);
    }

    @Override
    public boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException {
        if (context != null && context.getSessionInfo() != null && context.getSessionInfo().getSessionStatus() == SessionStatus.SESSION_ACTIVE) {
            block35: {
                if (request.getParameter("ReturnTo") == null) break block35;
                response.sendRedirect(request.getParameter("ReturnTo"));
                return true;
            }
            try {
                response.sendRedirect(MainDashboardView.getURL());
                return true;
            }
            catch (IOException e) {
                throw new ViewFailedException(e);
            }
            catch (URLInvalidException e) {
                throw new ViewFailedException(e);
            }
        }
        data.put("title", "Login");
        Vector<String> headers = new Vector<String>();
        headers.add(DashboardPreLoginPanel.getPanel(request, data));
        data.put("dashboard_headers", headers);
        data.put("show_splitter_border", false);
        data.put("alert", (Object)SessionMessages.MessageSeverity.ALERT);
        data.put("information", (Object)SessionMessages.MessageSeverity.INFORMATION);
        data.put("success", (Object)SessionMessages.MessageSeverity.SUCCESS);
        data.put("warning", (Object)SessionMessages.MessageSeverity.WARNING);
        if (request.getMethod().equalsIgnoreCase("POST") && request.getParameter("Username") != null) {
            ClientData clientData;
            String username = request.getParameter("Username");
            String password = request.getParameter("Password");
            data.put("username", username);
            try {
                clientData = new ClientData(InetAddress.getByName(request.getRemoteAddr()), request.getHeader("User-Agent"));
            }
            catch (UnknownHostException e1) {
                clientData = null;
            }
            String sessionID = this.authenticate(username, password, clientData);
            if (sessionID != null) {
                SessionManagement.SessionInfo oldSession = null;
                if (context != null) {
                    oldSession = context.getSessionInfo();
                }
                if (oldSession != null && oldSession.getSessionIdentifier() != null) {
                    SessionManagement sessionManagement = new SessionManagement(Application.getApplication());
                    try {
                        sessionManagement.terminateSession(oldSession.getSessionIdentifier());
                    }
                    catch (NoDatabaseConnectionException e) {
                        throw new ViewFailedException(e);
                    }
                    catch (SQLException e) {
                        throw new ViewFailedException(e);
                    }
                    catch (InputValidationException e) {
                        throw new ViewFailedException(e);
                    }
                }
                Cookie cookie = new Cookie("SessionID", sessionID);
                cookie.setPath("/");
                try {
                    if (Application.getApplication().getApplicationConfiguration().isSslEnabled()) {
                        cookie.setSecure(true);
                    }
                }
                catch (NoDatabaseConnectionException e1) {
                    throw new ViewFailedException(e1);
                }
                catch (SQLException e1) {
                    throw new ViewFailedException(e1);
                }
                catch (InputValidationException e1) {
                    throw new ViewFailedException(e1);
                }
                response.addCookie(cookie);
                try {
                    String forwardTo = request.getParameter("ForwardTo");
                    if (forwardTo != null) {
                        response.sendRedirect(forwardTo);
                    } else {
                        response.sendRedirect("/");
                    }
                }
                catch (IOException e) {
                    throw new ViewFailedException(e);
                }
                return true;
            }
            data.put("auth_failed", Boolean.TRUE);
            data.put("message", new Message("Authentication failed; credentials are incorrect", SessionMessages.MessageSeverity.ALERT));
        } else if (context != null && context.getSessionInfo() != null) {
            if (context.getSessionInfo().getSessionStatus() == SessionStatus.SESSION_ADMIN_TERMINATED) {
                data.put("message", new Message("Your session was terminated by an administrator", SessionMessages.MessageSeverity.ALERT));
            } else if (context.getSessionInfo().getSessionStatus() == SessionStatus.SESSION_EXPIRED) {
                data.put("message", new Message("Your session has expired", SessionMessages.MessageSeverity.INFORMATION));
            } else if (context.getSessionInfo().getSessionStatus() == SessionStatus.SESSION_INACTIVE) {
                data.put("message", new Message("Your session expired due to inactivity", SessionMessages.MessageSeverity.INFORMATION));
            } else if (context.getSessionInfo().getSessionStatus() == SessionStatus.SESSION_LIFETIME_EXCEEDED) {
                data.put("message", new Message("Your session has expired", SessionMessages.MessageSeverity.INFORMATION));
            }
            if (context.getUser() != null) {
                data.put("username", context.getUser().getUserName());
            }
        }
        if (request.getParameter("LoggedOut") != null) {
            data.put("message", new Message("You have been successfully logged out", SessionMessages.MessageSeverity.INFORMATION));
        }
        TemplateLoader.renderToResponse("Login.ftl", data, response);
        return true;
    }

    private String authenticate(String userName, String password, ClientData clientData) throws ViewFailedException {
        Authentication.AuthenticationResult result;
        Application app = Application.getApplication();
        if (userName == null || userName.length() == 0) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY);
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        Pattern nameRegex = Pattern.compile("[-A-Z0-9a-z_ .]{0,256}");
        Matcher matcher = nameRegex.matcher(userName);
        if (!matcher.matches()) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY);
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            return null;
        }
        if (userName.length() > 32) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY);
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_EMPTY, new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_LENGTH_EXCESSIVE, new EventLogField(EventLogField.FieldName.LENGTH, userName.length()), new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            return null;
        }
        LocalPasswordAuthentication localPasswordAuth = new LocalPasswordAuthentication(app);
        PasswordAuthenticationValidator passwordAuth = new PasswordAuthenticationValidator(password);
        try {
            result = localPasswordAuth.authenticate(userName, passwordAuth, clientData);
        }
        catch (NoSuchAlgorithmException e) {
            app.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (SQLException e) {
            app.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            app.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            app.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (NumericalOverflowException e) {
            app.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new ViewFailedException(e);
        }
        if (result.getAuthenticationStatus() == 5) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_ACCOUNT_DISABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_ACCOUNT_DISABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 6) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_USERNAME_BLOCKED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_USERNAME_BLOCKED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 4) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_ACCOUNT_DISABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_ACCOUNT_DISABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 1) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_PASSWORD_WRONG, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_PASSWORD_WRONG, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 2) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_PASSWORD_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_PASSWORD_ILLEGAL, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 3) {
            if (clientData == null) {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_INVALID, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            } else {
                app.logEvent(EventLogMessage.EventType.AUTHENTICATION_FAILED_USERNAME_INVALID, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName), new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            return null;
        }
        if (result.getAuthenticationStatus() == 0) {
            EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.AUTHENTICATION_SUCCESS, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, userName));
            try {
                SessionManagement sessionManagement = new SessionManagement(app);
                SessionManagement.SessionInfo sessionInfo = sessionManagement.getSessionInfo(result.getSessionIdentifier());
                message.addField(new EventLogField(EventLogField.FieldName.TARGET_USER_ID, sessionInfo.getUserId()));
                message.addField(new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, sessionInfo.getTrackingNumber()));
            }
            catch (Exception e) {
                app.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            }
            if (clientData != null) {
                message.addField(new EventLogField(EventLogField.FieldName.SOURCE_ADDRESS, clientData.getSourceAddress().toString()));
            }
            app.logEvent(message);
            return result.getSessionIdentifier();
        }
        app.logEvent(EventLogMessage.EventType.INTERNAL_ERROR, new EventLogField(EventLogField.FieldName.MESSAGE, "Invalid authentication result code"));
        return null;
    }

    public static class Message {
        private String message;
        private SessionMessages.MessageSeverity sev;

        public Message(String message, SessionMessages.MessageSeverity sev) {
            this.message = message;
            this.sev = sev;
        }

        public SessionMessages.MessageSeverity getSeverity() {
            return this.sev;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.message;
        }
    }
}

