/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;

public class LogoutView
extends View {
    public LogoutView() {
        super("Logout", "logout", new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        LogoutView view = new LogoutView();
        return view.createURL(new Object[0]);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, IOException, URLInvalidException, ViewNotFoundException {
        Cookie[] cookies = request.getCookies();
        String sessionID = null;
        Cookie[] cookieArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (cookie.getName().equals("SessionID")) {
                sessionID = cookie.getValue();
            }
            ++n2;
        }
        if (sessionID != null) {
            Application app = Application.getApplication();
            SessionManagement session_mgmt = new SessionManagement(app);
            try {
                SessionManagement.SessionInfo sessionInfo = session_mgmt.getSessionInfo(sessionID);
                EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.SESSION_ENDED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, sessionInfo.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, sessionInfo.getUserId()), new EventLogField(EventLogField.FieldName.SESSION_TRACKING_NUMBER, sessionInfo.getTrackingNumber()));
                session_mgmt.terminateSession(sessionID);
                app.logEvent(message);
            }
            catch (InputValidationException e) {
                app.logEvent(EventLogMessage.EventType.SESSION_ID_ILLEGAL, new EventLogField(EventLogField.FieldName.SESSION_ID, sessionID));
            }
            catch (SQLException e) {
                app.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                throw new ViewFailedException(e);
            }
            catch (NoDatabaseConnectionException e) {
                app.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
                throw new ViewFailedException(e);
            }
        }
        response.sendRedirect(String.valueOf(StandardViewList.getURL("login", new Object[0])) + "?LoggedOut");
        return true;
    }
}

