/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultLoader;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ScanRuleLoader;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.WebDiscoveryScanResultExport;

public class ScanResultExportView
extends View {
    public static final String VIEW_NAME = "scan_result_export";

    public ScanResultExportView() {
        super("ScanResult/Export", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        ScanRule rule;
        int scanResultID;
        block18: {
            SiteGroupManagement.SiteGroupDescriptor siteGroup;
            try {
                scanResultID = Integer.valueOf(args[0]);
            }
            catch (NumberFormatException e) {
                Dialog.getDialog(response, context, data, "A scan result with the given ID was not found", "Scan Result Not Found", Dialog.DialogType.WARNING);
                return true;
            }
            ScanResult scanResult = ScanResultLoader.getScanResult(scanResultID);
            data.put("scanResult", scanResult);
            try {
                rule = ScanRuleLoader.getScanRule(scanResult.getRuleID());
            }
            catch (NotFoundException e) {
                Dialog.getDialog(response, context, data, "The scan rule associated with the given scan result could not be found", "Scan Rule Not Found", Dialog.DialogType.WARNING);
                return true;
            }
            data.put("rule", rule);
            try {
                int siteGroupID = ScanRule.getAssociatedSiteGroupID(scanResult.getRuleID());
                SiteGroupManagement siteGroupMgmt = new SiteGroupManagement(Application.getApplication());
                siteGroup = siteGroupMgmt.getGroupDescriptor(siteGroupID);
            }
            catch (NotFoundException e) {
                Dialog.getDialog(response, context, data, "The site-group associated with the given scan result could not be found", "Site-group Not Found", Dialog.DialogType.WARNING);
                return true;
            }
            data.put("siteGroup", siteGroup);
            if (Shortcuts.canRead(context.getSessionInfo(), siteGroup.getObjectId(), "View scan result for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) break block18;
            Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to view this site-group");
            return true;
        }
        try {
            response.setHeader("Content-Type", "text/csv");
            response.setHeader("Content-Disposition", "attachment; filename=\"Scan_Result_" + scanResultID + ".csv\"");
            if (rule.getRuleType().equalsIgnoreCase("HTTP/Autodiscovery")) {
                WebDiscoveryScanResultExport view = new WebDiscoveryScanResultExport();
                return view.process(request, response, context, args, data);
            }
            throw new ViewFailedException("The view type \"" + rule.getRuleType() + "\" is not recognized");
        }
        catch (ScanRule.ScanResultLoadFailureException e) {
            Dialog.getDialog(response, context, data, "A scan result with the given ID was not found", "Scan Result Not Found", Dialog.DialogType.WARNING);
            return true;
        }
        catch (ScanRule.ScanRuleLoadFailureException e) {
            Dialog.getDialog(response, context, data, "The scan rule associated with the given scan result could not be found", "Scan Rule Not Found", Dialog.DialogType.WARNING);
            return true;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
    }
}

