/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.MainDashboardView;
import net.lukemurphey.nsia.web.views.SystemStatusView;

public class ShutdownView
extends View {
    public ShutdownView() {
        super("System/Shutdown", "system_shutdown", Pattern.compile("(Confirmed)?", 2));
    }

    public static String getURL() throws URLInvalidException {
        ShutdownView view = new ShutdownView();
        return view.createURL(new Object[0]);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        if (request.getParameter("Selected") != null && request.getParameter("Selected").equalsIgnoreCase("Cancel")) {
            response.sendRedirect(MainDashboardView.getURL());
            return true;
        }
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Shutdown", "Shutdown system")) {
                context.addMessage("You do not have permission to shutdown the system", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(SystemStatusView.getURL());
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        Shortcuts.addDashboardHeaders(request, response, data);
        boolean confirmed = false;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if ("Confirmed".equalsIgnoreCase(arg)) {
                confirmed = true;
            }
            ++n2;
        }
        if (confirmed) {
            Dialog.getDialog(response, context, data, "NSIA is shutting down. The web interface will no longer be available.", "Shutting Down", Dialog.DialogType.INFORMATION);
            Application.getApplication().shutdown(Application.ShutdownRequestSource.API);
        } else {
            Dialog.getOptionDialog(response, context, data, "Are you sure you want to shutdown NSIA?", "System Shutdown", Dialog.DialogType.INFORMATION, new Link("Shutdown", this.createURL("Confirmed")), new Link("Cancel", StandardViewList.getURL("main_dashboard", new Object[0])));
        }
        return true;
    }
}

