/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.forms.Field;
import net.lukemurphey.nsia.web.forms.FieldError;
import net.lukemurphey.nsia.web.forms.FieldErrors;
import net.lukemurphey.nsia.web.forms.Form;
import net.lukemurphey.nsia.web.forms.PatternValidator;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.SiteGroupView;

public class SiteGroupEditView
extends View {
    public static final String VIEW_NAME = "sitegroup";

    public SiteGroupEditView() {
        super("SiteGroup", VIEW_NAME, Pattern.compile("(New)|(Edit)", 2), Pattern.compile("[0-9]*", 2));
    }

    public static String getURL() throws URLInvalidException {
        SiteGroupEditView view = new SiteGroupEditView();
        return view.createURL("New");
    }

    public static String getURL(SiteGroupManagement.SiteGroupDescriptor siteGroup) throws URLInvalidException {
        SiteGroupEditView view = new SiteGroupEditView();
        return view.createURL("Edit", siteGroup.getGroupId());
    }

    private Form getSiteGroupForm() {
        Form form = new Form();
        form.addField(new Field("Name", new PatternValidator(Pattern.compile("[-a-z0-9. _]{1,32}", 2), "Name is not valid (can only contain letters, numbers, spaces, periods and underscores)")));
        form.addField(new Field("Description"));
        return form;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean performActions(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data, SiteGroupManagement.SiteGroupDescriptor siteGroup) throws ViewFailedException, IOException, URLInvalidException, ViewNotFoundException {
        try {
            SiteGroupManagement siteGroupManager = new SiteGroupManagement(Application.getApplication());
            if (!"POST".equalsIgnoreCase(request.getMethod())) return false;
            String name = request.getParameter("Name");
            String description = request.getParameter("Description");
            Form form = this.getSiteGroupForm();
            FieldErrors errors = form.validate(request);
            if (errors.size() > 0) {
                data.put("form_errors", errors);
                return false;
            }
            try {
                if (siteGroup == null) {
                    if (siteGroupManager.getGroupID(name) > 0) {
                        context.addMessage("A Sitegroup already exists with the given name", SessionMessages.MessageSeverity.WARNING);
                        return false;
                    }
                    int siteGroupID = siteGroupManager.addGroup(name, description);
                    if (siteGroupID > -1) {
                        Application.getApplication().logEvent(EventLogMessage.EventType.SITE_GROUP_ADDED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, name), new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, siteGroupID));
                        context.addMessage("Sitegroup created successfully", SessionMessages.MessageSeverity.SUCCESS);
                        response.sendRedirect(SiteGroupView.getURL(siteGroupID));
                        return true;
                    }
                    Application.getApplication().logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Add new site-group"), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, name));
                    context.addMessage("Sitegroup was not created successfully", SessionMessages.MessageSeverity.WARNING);
                    return false;
                }
                if (siteGroupManager.updateGroupInfo(siteGroup.getGroupId(), name, description)) {
                    Application.getApplication().logEvent(EventLogMessage.EventType.SITE_GROUP_MODIFIED, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, siteGroup.getGroupId()), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, siteGroup.getGroupName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
                    context.addMessage("Sitegroup updated successfully", SessionMessages.MessageSeverity.SUCCESS);
                    response.sendRedirect(SiteGroupView.getURL(siteGroup.getGroupId()));
                    return true;
                }
                Application.getApplication().logEvent(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField(EventLogField.FieldName.OPERATION, "Update site-group"), new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, siteGroup.getGroupId()), new EventLogField(EventLogField.FieldName.SITE_GROUP_NAME, siteGroup.getGroupName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
                context.addMessage("Site-group could not be updated", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(SiteGroupView.getURL(siteGroup.getGroupId()));
                return true;
            }
            catch (InputValidationException e) {
                if (!e.getFieldDescription().equalsIgnoreCase("SiteGroupName")) return false;
                errors.put(new FieldError("Name", e.getAttemptedValue(), "Name is invalid"));
                data.put("form_errors", errors);
                return false;
            }
        }
        catch (SQLException e2) {
            throw new ViewFailedException(e2);
        }
        catch (NoDatabaseConnectionException e3) {
            throw new ViewFailedException(e3);
        }
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        block23: {
            SiteGroupManagement.SiteGroupDescriptor siteGroup;
            block22: {
                int siteGroupID;
                siteGroup = null;
                SiteGroupManagement siteGroupManager = new SiteGroupManagement(Application.getApplication());
                if (args.length < 2) break block22;
                try {
                    siteGroupID = Integer.valueOf(args[1]);
                }
                catch (NumberFormatException e) {
                    Dialog.getDialog(response, context, data, "The Site-group ID provided is not valid", "Site-group ID Invalid", Dialog.DialogType.WARNING);
                    return true;
                }
                try {
                    siteGroup = siteGroupManager.getGroupDescriptor(siteGroupID);
                    data.put(VIEW_NAME, siteGroup);
                }
                catch (NotFoundException e) {
                    Dialog.getDialog(response, context, data, "No Site-group exists with the given ID", "Site-group ID Invalid", Dialog.DialogType.WARNING);
                    return true;
                }
            }
            Vector<Link> breadcrumbs = new Vector<Link>();
            breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
            if (siteGroup == null) {
                breadcrumbs.add(new Link("New Site Group", this.createURL("New")));
                data.put("title", "New Site Group");
            } else {
                breadcrumbs.add(new Link("Site-group: " + siteGroup.getGroupName(), StandardViewList.getURL("sitegroup_rules", siteGroup.getGroupId())));
                breadcrumbs.add(new Link("Edit Site-group", this.createURL("Edit", siteGroup.getGroupId())));
                data.put("title", "Edit " + siteGroup.getGroupName());
            }
            data.put("breadcrumbs", breadcrumbs);
            data.put("menu", Menu.getSiteGroupMenu(context, siteGroup));
            Shortcuts.addDashboardHeaders(request, response, data);
            try {
                if (siteGroup == null) {
                    Shortcuts.checkRight(context.getSessionInfo(), "SiteGroups.Add", "Create new site-group");
                } else {
                    Shortcuts.checkModify(context.getSessionInfo(), siteGroup.getObjectId(), "Edit site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")");
                }
            }
            catch (NoSessionException e) {
                throw new ViewFailedException(e);
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
            catch (InsufficientPermissionException e) {
                if (siteGroup == null) {
                    data.put("permission_denied_message", "You do not have permission to create new site-groups.");
                    TemplateLoader.renderToResponse("PermissionDenied.ftl", data, response);
                } else {
                    data.put("permission_denied_message", "You do not have permission to edit this site-group.");
                    data.put("permission_denied_link", new Link("View Site Group", SiteGroupView.getURL(siteGroup)));
                    TemplateLoader.renderToResponse("PermissionDenied.ftl", data, response);
                }
                return true;
            }
            if (!this.performActions(request, response, context, args, data, siteGroup)) break block23;
            return true;
        }
        try {
            TemplateLoader.renderToResponse("SiteGroupEdit.ftl", data, response);
            return true;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
    }
}

