/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DuplicateEntryException;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.RuleScanWorker;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.SiteGroupScanResult;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.DefinitionSetLoadException;
import net.lukemurphey.nsia.scan.HttpSeekingScanRule;
import net.lukemurphey.nsia.scan.RuleBaselineException;
import net.lukemurphey.nsia.scan.ScanData;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanResultCode;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.scan.ScanRuleLoader;
import net.lukemurphey.nsia.scan.ServiceScanRule;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import org.apache.commons.lang.StringEscapeUtils;

public class SiteGroupView
extends View {
    public static final String VIEW_NAME = "sitegroup_rules";

    public SiteGroupView() {
        super("SiteGroup", VIEW_NAME, Pattern.compile("[0-9]+", 2));
    }

    public static String getURL(SiteGroupManagement.SiteGroupDescriptor siteGroup) throws URLInvalidException {
        return SiteGroupView.getURL(siteGroup.getGroupId());
    }

    public static String getURL(int siteGroupID) throws URLInvalidException {
        SiteGroupView view = new SiteGroupView();
        return view.createURL(siteGroupID);
    }

    public static String getURL(long siteGroupID) throws URLInvalidException {
        SiteGroupView view = new SiteGroupView();
        return view.createURL(siteGroupID);
    }

    protected RuleResult getResults(SiteGroupManagement.SiteGroupDescriptor sitegroup) throws SQLException, InputValidationException, NoDatabaseConnectionException, NotFoundException, ScanRule.ScanResultLoadFailureException, ScanRule.ScanRuleLoadFailureException {
        if (sitegroup == null) {
            return null;
        }
        ScanResult[] scanResults = null;
        SiteGroupScanResult siteGroupStatus = null;
        ScanData scanData = new ScanData(Application.getApplication());
        siteGroupStatus = scanData.getSiteGroupStatus(sitegroup.getGroupId());
        scanResults = siteGroupStatus.getScanResults();
        ScanRule[] scanRules = ScanRuleLoader.getScanRules(sitegroup.getGroupId());
        Vector<RuleStatusDescriptor> ruleStatues = new Vector<RuleStatusDescriptor>();
        int c = 0;
        while (c < scanResults.length) {
            boolean scanResultObsoleted = false;
            boolean scanRuleAvailable = false;
            ScanRule relatedRule = null;
            int d = 0;
            while (d < scanRules.length) {
                if (scanResults[c].getRuleID() == scanRules[d].getRuleId()) {
                    scanRuleAvailable = true;
                    relatedRule = scanRules[d];
                    if (scanRules[d].isScanDataObsolete()) {
                        scanResultObsoleted = true;
                    }
                }
                ++d;
            }
            int deviations = scanResults[c].getDeviations();
            String target = relatedRule != null && relatedRule.getSpecimenDescription() != null ? relatedRule.getSpecimenDescription() : (scanResults[c].getSpecimenDescription() != null ? scanResults[c].getSpecimenDescription() : "");
            long ruleId = scanResults[c].getRuleID();
            if (scanRuleAvailable) {
                RuleState level = scanResults[c].getDeviations() > 0 ? RuleState.STAT_RED : (!scanResults[c].getResultCode().equals(ScanResultCode.SCAN_COMPLETED) ? RuleState.STAT_YELLOW : RuleState.STAT_GREEN);
                if (scanResultObsoleted || deviations < 0) {
                    ruleStatues.add(new RuleStatusDescriptor(level, deviations, scanResults[c].getRuleType(), target, ruleId));
                } else if (scanResults[c].getDeviations() == 1) {
                    ruleStatues.add(new RuleStatusDescriptor(level, deviations, scanResults[c].getRuleType(), target, ruleId, "1 deviation"));
                } else if (scanResults[c].getDeviations() > 1) {
                    ruleStatues.add(new RuleStatusDescriptor(level, deviations, scanResults[c].getRuleType(), target, ruleId, String.valueOf(scanResults[c].getDeviations()) + " deviations"));
                } else {
                    ruleStatues.add(new RuleStatusDescriptor(level, deviations, scanResults[c].getRuleType(), target, ruleId, scanResults[c].getResultCode().getDescription()));
                }
            }
            ++c;
        }
        c = 0;
        while (c < scanRules.length) {
            boolean found = false;
            int d = 0;
            while (d < scanResults.length) {
                if (scanResults[d].getRuleID() == scanRules[c].getRuleId()) {
                    found = true;
                }
                ++d;
            }
            if (!found) {
                String target = StringEscapeUtils.escapeHtml((String)scanRules[c].getSpecimenDescription());
                long ruleId = scanRules[c].getRuleId();
                ruleStatues.add(new RuleStatusDescriptor(RuleState.STAT_BLUE, -1, scanRules[c].getRuleType(), target, ruleId));
            }
            ++c;
        }
        RuleResult result = new RuleResult();
        result.ruleStatuses = ruleStatues;
        result.scanResults = scanResults;
        result.scanRules = scanRules;
        return result;
    }

    public static String getUniqueScanWorkerID(int userID, long siteGroupID) {
        return "Scan by user ID " + userID + " for site-group ID " + siteGroupID;
    }

    private int deleteRules(RequestContext context, long[] rules) throws SQLException, NoDatabaseConnectionException, NotFoundException, InputValidationException, InsufficientPermissionException, GeneralizedException, NoSessionException, ScanRule.ScanRuleLoadFailureException {
        int rulesDeleted = 0;
        long[] lArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            long ruleID = lArray[n2];
            SiteGroupManagement.SiteGroupDescriptor siteGroup = ScanRule.getAssociatedSiteGroup(ruleID);
            ScanRule scanRule = ScanRuleLoader.getScanRule(ruleID);
            Shortcuts.checkDelete(context.getSessionInfo(), siteGroup.getObjectId(), "Delete rule " + ruleID + " (" + scanRule.getRuleType() + "\\" + scanRule.getSpecimenDescription() + ") for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")");
            ScanRule.deleteRule(ruleID);
            Application.getApplication().logEvent(new EventLogMessage(EventLogMessage.EventType.RULE_DELETED, new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()), new EventLogField(EventLogField.FieldName.RULE_ID, ruleID)));
            ++rulesDeleted;
            ++n2;
        }
        context.addMessage(String.valueOf(rulesDeleted) + " rules have been deleted", SessionMessages.MessageSeverity.SUCCESS);
        return rulesDeleted;
    }

    private void baselineRules(RequestContext context, long[] rules) throws SQLException, NoDatabaseConnectionException, DefinitionSetLoadException, InputValidationException, ScriptException, IOException, NotFoundException, ScanRule.ScanRuleLoadFailureException, InsufficientPermissionException, GeneralizedException, NoSessionException {
        int rulesBaselined = 0;
        int rulesNotBaselined = 0;
        long[] lArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            long ruleID = lArray[n2];
            ScanRule rule = ScanRuleLoader.getScanRule(ruleID);
            SiteGroupManagement.SiteGroupDescriptor siteGroup = ScanRule.getAssociatedSiteGroup(ruleID);
            ScanRule scanRule = ScanRuleLoader.getScanRule(ruleID);
            Shortcuts.checkExecute(context.getSessionInfo(), siteGroup.getObjectId(), "Scan rule " + ruleID + " (" + scanRule.getRuleType() + "\\" + scanRule.getSpecimenDescription() + ") for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")");
            if (rule instanceof HttpSeekingScanRule) {
                HttpSeekingScanRule httpRule = (HttpSeekingScanRule)rule;
                try {
                    httpRule.baseline();
                    ++rulesBaselined;
                }
                catch (RuleBaselineException e) {
                    EventLogMessage message = new EventLogMessage(EventLogMessage.EventType.RULE_BASELINE_FAILED, new EventLogField(EventLogField.FieldName.SITE_GROUP_ID, siteGroup.getGroupId()), new EventLogField(EventLogField.FieldName.RULE_ID, ruleID), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
                    Application.getApplication().logExceptionEvent(message, (Throwable)e);
                    ++rulesNotBaselined;
                }
            } else if (rule instanceof ServiceScanRule) {
                ServiceScanRule serviceRule = (ServiceScanRule)rule;
                serviceRule.baseline();
                ++rulesBaselined;
            }
            ++n2;
        }
        if (rulesBaselined > 0) {
            context.addMessage(String.valueOf(rulesBaselined) + " rules have been re-baselined", SessionMessages.MessageSeverity.SUCCESS);
        }
        if (rulesNotBaselined > 0) {
            context.addMessage(String.valueOf(rulesNotBaselined) + " rules could not re-baselined", SessionMessages.MessageSeverity.ALERT);
        }
    }

    /*
     * Unable to fully structure code
     */
    private Application.WorkerThreadDescriptor scanRules(RequestContext context, long[] rules, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException, DuplicateEntryException, ViewFailedException, SQLException, NoDatabaseConnectionException, NotFoundException, InputValidationException {
        userDescriptor = context.getUser();
        worker = new RuleScanWorker(rules);
        siteGroupID = -1L;
        appRes = Application.getApplication();
        try {
            var13_8 = rules;
            var12_9 = rules.length;
            var11_10 = 0;
            while (var11_10 < var12_9) {
                ruleID = var13_8[var11_10];
                siteGroup = ScanRule.getAssociatedSiteGroup(ruleID);
                siteGroupID = siteGroup.getGroupId();
                scanRule = ScanRuleLoader.getScanRule(ruleID);
                Shortcuts.checkExecute(context.getSessionInfo(), siteGroup.getObjectId(), "Scan rule " + ruleID + " (" + scanRule.getRuleType() + "\\" + scanRule.getSpecimenDescription() + ") for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")");
                ++var11_10;
            }
            threadDesc = appRes.addWorkerToQueue(worker, SiteGroupView.getUniqueScanWorkerID(context.getSessionInfo().getUserId(), siteGroupID), context.getSessionInfo().getUserId());
            thread = new Thread(worker);
            thread.setName("Scanner started by user " + userDescriptor.getUserName());
            thread.start();
            return threadDesc;
        }
        catch (SQLException e) {
            appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new GeneralizedException();
        }
        catch (DuplicateEntryException e) {
            throw e;
        }
        catch (ScanRule.ScanRuleLoadFailureException e) {
            rulesString = new StringBuffer();
            c = 0;
            ** while (c < rules.length)
        }
lbl-1000:
        // 1 sources

        {
            if (c == 0) {
                rulesString.append("[").append(c);
            } else {
                rulesString.append(",").append(c);
            }
            ++c;
            continue;
        }
lbl39:
        // 1 sources

        rulesString.append("]");
        Application.getApplication().logExceptionEvent(new EventLogMessage(EventLogMessage.EventType.OPERATION_FAILED, new EventLogField[]{new EventLogField(EventLogField.FieldName.OPERATION, "Scan rule"), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, userDescriptor.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, userDescriptor.getUserName()), new EventLogField(EventLogField.FieldName.RULE_ID, rulesString.toString())}), (Throwable)e);
        throw new ViewFailedException(e);
    }

    protected long[] getRules(HttpServletRequest request) {
        Vector<Long> ruleIDs = new Vector<Long>();
        String[] stringArray = request.getParameterValues("RuleID");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            ruleIDs.add(Long.valueOf(param));
            ++n2;
        }
        long[] a = new long[ruleIDs.size()];
        int c = 0;
        while (c < a.length) {
            a[c] = (Long)ruleIDs.get(c);
            ++c;
        }
        return a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        try {
            RuleResult result;
            Shortcuts.addDashboardHeaders(request, response, data);
            SiteGroupManagement.SiteGroupDescriptor siteGroup = null;
            if (args.length <= 0) {
                Dialog.getDialog(response, context, data, "The site-group ID provided is not valid", "site-group ID Invalid", Dialog.DialogType.WARNING);
                return true;
            }
            SiteGroupManagement mgmr = new SiteGroupManagement(Application.getApplication());
            try {
                siteGroup = mgmr.getGroupDescriptor(Integer.valueOf(args[0]));
            }
            catch (NotFoundException e) {
                Dialog.getDialog(response, context, data, "The site-group ID provided is not valid", "site-group ID Invalid", Dialog.DialogType.WARNING);
                return true;
            }
            catch (NumberFormatException e) {
                Dialog.getDialog(response, context, data, "The site-group ID provided is not valid", "site-group ID Invalid", Dialog.DialogType.WARNING);
                return true;
            }
            data.put("title", "Site-groups");
            Vector<Link> breadcrumbs = new Vector<Link>();
            breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
            if (siteGroup != null) {
                breadcrumbs.add(new Link("Site-group: " + siteGroup.getGroupName(), this.createURL(siteGroup.getGroupId())));
            }
            data.put("breadcrumbs", breadcrumbs);
            data.put("menu", Menu.getSiteGroupMenu(context, siteGroup));
            if (!Shortcuts.canRead(context.getSessionInfo(), siteGroup.getObjectId(), "View site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to view this site-group");
                return true;
            }
            Application.WorkerThreadDescriptor worker = null;
            if (siteGroup != null) {
                String threadName = SiteGroupView.getUniqueScanWorkerID(context.getSessionInfo().getUserId(), siteGroup.getGroupId());
                worker = Application.getApplication().getWorkerThread(threadName);
            }
            boolean isAjax = request.getParameter("AJAX") != null;
            boolean startedNow = false;
            if (!isAjax) {
                if ("Scan".equalsIgnoreCase(request.getParameter("Action"))) {
                    if (request.getParameterValues("RuleID") == null) {
                        context.addMessage("No rules were selected", SessionMessages.MessageSeverity.WARNING);
                    } else {
                        if (!Shortcuts.canExecute(context.getSessionInfo(), siteGroup.getObjectId(), "Scan rules for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                            Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to scan this site-group");
                            return true;
                        }
                        startedNow = true;
                        try {
                            worker = this.scanRules(context, this.getRules(request), true);
                        }
                        catch (DuplicateEntryException duplicateEntryException) {
                        }
                        catch (InsufficientPermissionException e) {
                            Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to scan this site-group");
                            return true;
                        }
                    }
                }
                if ("Cancel".equalsIgnoreCase(request.getParameter("Selected"))) {
                    if (!Shortcuts.canExecute(context.getSessionInfo(), siteGroup.getObjectId(), "Cancel scanning of rules for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to cancel scans for this site-group");
                        return true;
                    }
                    worker.getWorkerThread().terminate();
                }
                if ("Baseline".equalsIgnoreCase(request.getParameter("Action"))) {
                    if (!Shortcuts.canExecute(context.getSessionInfo(), siteGroup.getObjectId(), "Baseline scanning of rules for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to execute scans or baseline rules for this site-group");
                        return true;
                    }
                    if (request.getParameterValues("RuleID") == null) {
                        context.addMessage("No rules were selected", SessionMessages.MessageSeverity.WARNING);
                    } else {
                        try {
                            this.baselineRules(context, this.getRules(request));
                        }
                        catch (InsufficientPermissionException e) {
                            Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to baseline rules in this site-group");
                            return true;
                        }
                    }
                }
                if ("Delete".equalsIgnoreCase(request.getParameter("Action"))) {
                    if (!Shortcuts.canDelete(context.getSessionInfo(), siteGroup.getObjectId(), "Delete rules for site-group " + siteGroup.getGroupId() + " (" + siteGroup.getGroupName() + ")")) {
                        Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to delete rules in this site-group");
                        return true;
                    }
                    if (request.getParameterValues("RuleID") == null) {
                        context.addMessage("No rules were selected", SessionMessages.MessageSeverity.WARNING);
                    } else {
                        try {
                            this.deleteRules(context, this.getRules(request));
                        }
                        catch (InsufficientPermissionException e) {
                            Shortcuts.getPermissionDeniedDialog(response, data, "You do not permission to delete rules from this site-group");
                            return true;
                        }
                    }
                }
            }
            if (isAjax && worker == null) {
                response.getWriter().print(Dialog.getProgressDialog("Scanning complete", "Scanning", 100, new Link("OK", this.createURL(siteGroup.getGroupId()))));
                return true;
            }
            if (isAjax && (worker == null || worker.getWorkerThread().getStatus() == WorkerThread.State.STOPPED)) {
                response.getWriter().print(Dialog.getProgressDialog(worker.getWorkerThread().getStatusDescription(), worker.getWorkerThread().getTaskDescription(), 100, new Link("OK", this.createURL(siteGroup.getGroupId()))));
                return true;
            }
            if (isAjax) {
                response.getWriter().print(Dialog.getProgressDialog(worker.getWorkerThread().getStatusDescription(), worker.getWorkerThread().getTaskDescription(), worker.getWorkerThread().getProgress(), new Link("Cancel", this.createURL(siteGroup.getGroupId()))));
                return true;
            }
            Shortcuts.addDashboardHeaders(request, response, data);
            if (worker != null && (startedNow || worker.getWorkerThread().getStatus() == WorkerThread.State.STARTING || worker.getWorkerThread().getStatus() == WorkerThread.State.STARTED)) {
                data.put("ajaxurl", String.valueOf(this.createURL(siteGroup.getGroupId())) + "?AJAX=True");
                data.put("title", "Scanning");
                data.put("noajaxurl", this.createURL(siteGroup.getGroupId()));
                data.put("content", Dialog.getProgressDialog(worker.getWorkerThread().getStatusDescription(), worker.getWorkerThread().getTaskDescription(), worker.getWorkerThread().getProgress(), new Link("Cancel", this.createURL(siteGroup.getGroupId()))));
                response.getWriter().println(TemplateLoader.renderToString("AJAXProgressDialog.ftl", data));
                return true;
            }
            try {
                result = this.getResults(siteGroup);
            }
            catch (NoDatabaseConnectionException e) {
                throw new ViewFailedException(e);
            }
            catch (SQLException e) {
                throw new ViewFailedException(e);
            }
            catch (NotFoundException e) {
                throw new ViewFailedException(e);
            }
            catch (ScanRule.ScanResultLoadFailureException e) {
                throw new ViewFailedException(e);
            }
            catch (ScanRule.ScanRuleLoadFailureException e) {
                throw new ViewFailedException(e);
            }
            data.put("sitegroup", siteGroup);
            if (result != null) {
                data.put("scanrules", result.scanRules);
                data.put("scanresults", result.scanResults);
                data.put("rules", result.ruleStatuses);
            }
            data.put("STAT_GREEN", (Object)RuleState.STAT_GREEN);
            data.put("STAT_BLUE", (Object)RuleState.STAT_BLUE);
            data.put("STAT_YELLOW", (Object)RuleState.STAT_YELLOW);
            data.put("STAT_RED", (Object)RuleState.STAT_RED);
            if (siteGroup != null) {
                Shortcuts.addDashboardHeaders(request, response, data, this.createURL(siteGroup.getGroupId()));
                TemplateLoader.renderToResponse("SiteGroup.ftl", data, response);
            }
            return true;
        }
        catch (SQLException e) {
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            throw new ViewFailedException(e);
        }
        catch (NotFoundException e) {
            throw new ViewFailedException(e);
        }
        catch (DefinitionSetLoadException e) {
            throw new ViewFailedException(e);
        }
        catch (ScriptException e) {
            throw new ViewFailedException(e);
        }
        catch (ScanRule.ScanRuleLoadFailureException e) {
            throw new ViewFailedException(e);
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        catch (NoSessionException e) {
            throw new ViewFailedException(e);
        }
    }

    public static class RuleResult {
        Vector<RuleStatusDescriptor> ruleStatuses;
        ScanRule[] scanRules;
        ScanResult[] scanResults;
    }

    public static enum RuleState {
        STAT_RED,
        STAT_YELLOW,
        STAT_GREEN,
        STAT_BLUE;

    }

    public static class RuleStatusDescriptor {
        private RuleState status;
        private int deviations;
        private String ruleType;
        private String description;
        private long ruleID;
        private String statusDescription;

        public RuleStatusDescriptor(RuleState state, int deviations, String ruleType, String description, long ruleID, String message) {
            this.status = state;
            this.deviations = deviations;
            this.ruleType = ruleType;
            this.description = description;
            this.ruleID = ruleID;
            this.statusDescription = message;
        }

        public RuleStatusDescriptor(RuleState state, int deviations, String ruleType, String description, long ruleID) {
            this.status = state;
            this.deviations = deviations;
            this.ruleType = ruleType;
            this.description = description;
            this.ruleID = ruleID;
        }

        public int getDeviations() {
            return this.deviations;
        }

        public String getStatusDescription() {
            return this.statusDescription;
        }

        public RuleState getStatus() {
            return this.status;
        }

        public String getType() {
            return this.ruleType;
        }

        public long getID() {
            return this.ruleID;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

