/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.WorkerThread;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class TaskListView
extends View {
    public TaskListView() {
        super("System/Tasks", "task_list", Pattern.compile("[-A-Za-z_0-9]*", 2));
    }

    public static String getURL() throws URLInvalidException {
        TaskListView view = new TaskListView();
        return view.createURL(new Object[0]);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        Shortcuts.addDashboardHeaders(request, response, data, this.createURL(new Object[0]));
        data.put("menu", Menu.getSystemMenu(context));
        data.put("title", "Task List");
        Vector<Link> breadcrumbs = new Vector<Link>();
        breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
        breadcrumbs.add(new Link("System Status", StandardViewList.getURL("system_status", new Object[0])));
        breadcrumbs.add(new Link("Task List", StandardViewList.getURL("task_list", new Object[0])));
        data.put("breadcrumbs", breadcrumbs);
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "System.Information.View", "View running tasks")) {
                Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission view the running tasks");
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        Application.WorkerThreadDescriptor[] threads = Application.getApplication().getWorkerThreadQueue(true);
        TaskDescriptor[] tasks = new TaskDescriptor[threads.length];
        int c = 0;
        while (c < threads.length) {
            tasks[c] = new TaskDescriptor(threads[c].getWorkerThread(), threads[c].getUserID(), threads[c].getUniqueName());
            ++c;
        }
        data.put("tasks", tasks);
        TemplateLoader.renderToResponse("TaskList.ftl", data, response);
        return true;
    }

    public static class TaskDescriptor {
        WorkerThread thread;
        UserManagement.UserDescriptor user;
        String uniqueName;

        public TaskDescriptor(WorkerThread thread, UserManagement.UserDescriptor user, String uniqueName) {
            this.thread = thread;
            this.user = user;
            this.uniqueName = uniqueName;
        }

        public TaskDescriptor(WorkerThread thread, int userID, String uniqueName) throws ViewFailedException {
            if (userID >= 0) {
                UserManagement userManagement = new UserManagement(Application.getApplication());
                try {
                    this.user = userManagement.getUserDescriptor(userID);
                }
                catch (SQLException e) {
                    throw new ViewFailedException(e);
                }
                catch (NoDatabaseConnectionException e) {
                    throw new ViewFailedException(e);
                }
                catch (NotFoundException e) {
                    throw new ViewFailedException(e);
                }
            } else {
                this.user = null;
            }
            this.thread = thread;
            this.uniqueName = uniqueName;
        }

        public UserManagement.UserDescriptor getUser() {
            return this.user;
        }

        public String getTaskDescription() {
            return this.thread.getTaskDescription();
        }

        public String getStatusDescription() {
            return this.thread.getStatusDescription();
        }

        public int getProgress() {
            return this.thread.getProgress();
        }

        public String getUniqueName() {
            return this.uniqueName;
        }
    }
}

