/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.UserView;

public class UserEnableView
extends View {
    public UserEnableView() {
        super("User/Enable", "user_enable", Pattern.compile("[0-9]+", 2));
    }

    public static String getURL(UserManagement.UserDescriptor user) throws URLInvalidException {
        UserEnableView view = new UserEnableView();
        return view.createURL(user.getUserID());
    }

    public boolean enableUser(RequestContext context, int userID) throws ViewFailedException {
        Application app;
        block5: {
            app = Application.getApplication();
            UserManagement userManagement = new UserManagement(Application.getApplication());
            if (!userManagement.enableAccount(userID)) break block5;
            app.logEvent(EventLogMessage.EventType.USER_REENABLED, new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userID), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
            return true;
        }
        try {
            app.logEvent(EventLogMessage.EventType.USER_ID_INVALID, new EventLogField(EventLogField.FieldName.TARGET_USER_ID, userID), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getUser().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getUser().getUserID()));
            return true;
        }
        catch (SQLException e) {
            app.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            app.logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (InputValidationException e) {
            app.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
            throw new ViewFailedException(e);
        }
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        int userID = -1;
        if (args.length <= 0) {
            Dialog.getDialog(response, context, data, "The User ID was not provided.", "User ID Invalid", Dialog.DialogType.WARNING);
            return true;
        }
        try {
            userID = Integer.valueOf(args[0]);
        }
        catch (NumberFormatException e) {
            Dialog.getDialog(response, context, data, "The User ID provided is invalid.", "User ID Invalid", Dialog.DialogType.WARNING);
            return true;
        }
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "Users.Edit", "Enable user ID " + userID)) {
                context.addMessage("You do not have permission to enable users", SessionMessages.MessageSeverity.WARNING);
                response.sendRedirect(UserView.getURL(userID));
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        this.enableUser(context, userID);
        context.addMessage("User successfully enabled", SessionMessages.MessageSeverity.SUCCESS);
        response.sendRedirect(UserView.getURL(userID));
        return true;
    }
}

