/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.LocalPasswordAuthentication;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.NumericalOverflowException;
import net.lukemurphey.nsia.PasswordAuthenticationValidator;
import net.lukemurphey.nsia.PasswordInvalidException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogField;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.SessionMessages;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.forms.Field;
import net.lukemurphey.nsia.web.forms.FieldError;
import net.lukemurphey.nsia.web.forms.FieldErrors;
import net.lukemurphey.nsia.web.forms.Form;
import net.lukemurphey.nsia.web.forms.PasswordValidator;
import net.lukemurphey.nsia.web.templates.TemplateLoader;
import net.lukemurphey.nsia.web.views.Dialog;
import net.lukemurphey.nsia.web.views.UserEditView;
import net.lukemurphey.nsia.web.views.UserView;
import net.lukemurphey.nsia.web.views.UsersView;

public class UserPasswordUpdateView
extends View {
    public static final String VIEW_NAME = "user_password";

    public UserPasswordUpdateView() {
        super("User/UpdatePassword", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    public static String getURL(UserManagement.UserDescriptor user) throws URLInvalidException {
        UserPasswordUpdateView view = new UserPasswordUpdateView();
        return view.createURL(user.getUserID());
    }

    private boolean performActions(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data, UserManagement.UserDescriptor user) throws ViewFailedException, NotFoundException, PasswordInvalidException, IOException {
        block11: {
            try {
                UserManagement userManager = new UserManagement(Application.getApplication());
                if (!"POST".equalsIgnoreCase(request.getMethod())) break block11;
                UserPasswordUpdateForm form = new UserPasswordUpdateForm();
                FieldErrors errors = ((Form)form).validate(request);
                if (errors.size() > 0) {
                    data.put("form_errors", errors);
                    break block11;
                }
                LocalPasswordAuthentication localAuth = new LocalPasswordAuthentication(Application.getApplication());
                System.out.print("Password: " + request.getParameter("YourPassword"));
                if (!localAuth.checkPassword(user.getUserID(), new PasswordAuthenticationValidator(request.getParameter("YourPassword")))) {
                    errors.put(new FieldError("YourPassword", "", "Your current password is incorrect"));
                    data.put("form_errors", errors);
                    throw new PasswordInvalidException();
                }
                String newPassword = request.getParameter("Password");
                userManager.changePassword(user, newPassword);
                Application.getApplication().logEvent(EventLogMessage.EventType.USER_PASSWORD_CHANGED, new EventLogField(EventLogField.FieldName.TARGET_USER_NAME, user.getUserName()), new EventLogField(EventLogField.FieldName.TARGET_USER_ID, user.getUserID()), new EventLogField(EventLogField.FieldName.SOURCE_USER_NAME, context.getSessionInfo().getUserName()), new EventLogField(EventLogField.FieldName.SOURCE_USER_ID, context.getSessionInfo().getUserId()));
                if (user != null && context.getUser() != null && user.getUserID() == context.getUser().getUserID()) {
                    context.addMessage("Your password was successfully updated", SessionMessages.MessageSeverity.SUCCESS);
                } else {
                    context.addMessage("The password for the " + user.getUserName() + " account was successfully updated", SessionMessages.MessageSeverity.SUCCESS);
                }
                response.sendRedirect(UserView.getURL(user));
                return true;
            }
            catch (SQLException e) {
                throw new ViewFailedException(e);
            }
            catch (NoDatabaseConnectionException e) {
                throw new ViewFailedException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ViewFailedException(e);
            }
            catch (InputValidationException e) {
                throw new ViewFailedException(e);
            }
            catch (NumericalOverflowException e) {
                throw new ViewFailedException(e);
            }
            catch (URLInvalidException e) {
                throw new ViewFailedException(e);
            }
        }
        return false;
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        UserManagement.UserDescriptor user;
        block18: {
            user = null;
            if (args.length >= 1) {
                int userID;
                try {
                    userID = Integer.valueOf(args[0]);
                }
                catch (NumberFormatException e) {
                    Dialog.getDialog(response, context, data, "The User ID provided is not valid", "User ID Invalid", Dialog.DialogType.WARNING);
                    return true;
                }
                UserManagement userMgmt = new UserManagement(Application.getApplication());
                try {
                    user = userMgmt.getUserDescriptor(userID);
                }
                catch (NotFoundException e) {
                    Dialog.getDialog(response, context, data, "No user was found with the given ID", "User Not Found", Dialog.DialogType.WARNING);
                    return true;
                }
                catch (SQLException e) {
                    throw new ViewFailedException(e);
                }
                catch (NoDatabaseConnectionException e) {
                    throw new ViewFailedException(e);
                }
                if (user == null) {
                    Dialog.getDialog(response, context, data, "No user was found with the given ID", "User Not Found", Dialog.DialogType.WARNING);
                    return true;
                }
                data.put("user", user);
            }
            if (user == null) {
                Dialog.getDialog(response, context, data, "No user provided to update", "User Not Found", Dialog.DialogType.WARNING);
                return true;
            }
            try {
                if (context.getUser().getUserID() != user.getUserID()) break block18;
                if (!Shortcuts.hasRight(context.getSessionInfo(), "Users.UpdateOwnPassword", "Update user's own password")) {
                    context.addMessage("You do not have permission to update your password", SessionMessages.MessageSeverity.WARNING);
                    response.sendRedirect(UserView.getURL(user));
                    return true;
                }
            }
            catch (GeneralizedException e) {
                throw new ViewFailedException(e);
            }
        }
        if (!Shortcuts.hasRight(context.getSessionInfo(), "Users.UpdatePassword", "Update another user's password")) {
            context.addMessage("You do not have permission to update user passwords", SessionMessages.MessageSeverity.WARNING);
            response.sendRedirect(UserView.getURL(user));
            return true;
        }
        try {
            if (this.performActions(request, response, context, args, data, user)) {
                return true;
            }
        }
        catch (PasswordInvalidException e) {
        }
        catch (NotFoundException e) {
            Dialog.getDialog(response, context, data, "No user was found with the given ID", "User Not Found", Dialog.DialogType.WARNING);
            return true;
        }
        data.put("menu", Menu.getUserMenu(context, user));
        Vector<Link> breadcrumbs = new Vector<Link>();
        breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
        breadcrumbs.add(new Link("User Management", UsersView.getURL()));
        breadcrumbs.add(new Link("View User: " + user.getUserName(), UserView.getURL(user)));
        breadcrumbs.add(new Link("Edit User", UserEditView.getURL(user)));
        breadcrumbs.add(new Link("Update Password", this.createURL(user.getUserID())));
        data.put("breadcrumbs", breadcrumbs);
        data.put("title", "Update Password");
        Shortcuts.addDashboardHeaders(request, response, data);
        TemplateLoader.renderToResponse("UserPasswordUpdate.ftl", data, response);
        return true;
    }

    private static class UserPasswordUpdateForm
    extends Form {
        public UserPasswordUpdateForm() {
            this.addField(new Field("YourPassword"));
            this.addField(new Field("Password", new PasswordValidator()));
            this.addField(new Field("PasswordConfirm"));
        }

        @Override
        public FieldErrors validate(HttpServletRequest request) {
            FieldErrors errors = super.validate(request);
            if (!errors.isEmpty()) {
                return errors;
            }
            if (request.getParameter("Password") != null && !request.getParameter("Password").equalsIgnoreCase(request.getParameter("PasswordConfirm"))) {
                errors.put(new FieldError("Password", request.getParameter("PasswordConfirm"), "The passwords are not identical"));
            }
            return errors;
        }
    }
}

