/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.web.Link;
import net.lukemurphey.nsia.web.Menu;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.Shortcuts;
import net.lukemurphey.nsia.web.StandardViewList;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;
import net.lukemurphey.nsia.web.templates.TemplateLoader;

public class UsersView
extends View {
    public static final String VIEW_NAME = "users_list";

    public UsersView() {
        super("Users", VIEW_NAME, new Pattern[0]);
    }

    public static String getURL() throws URLInvalidException {
        UsersView v = new UsersView();
        return v.createURL(new Object[0]);
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        UserManagement.UserDescriptor[] users;
        data.put("menu", Menu.getUserMenu(context));
        Vector<Link> breadcrumbs = new Vector<Link>();
        breadcrumbs.add(new Link("Main Dashboard", StandardViewList.getURL("main_dashboard", new Object[0])));
        breadcrumbs.add(new Link("User Management", this.createURL(new Object[0])));
        data.put("breadcrumbs", breadcrumbs);
        Shortcuts.addDashboardHeaders(request, response, data);
        data.put("title", "Users");
        try {
            if (!Shortcuts.hasRight(context.getSessionInfo(), "Users.View", "List all users")) {
                Shortcuts.getPermissionDeniedDialog(response, data, "You do not have permission to view the users");
                return true;
            }
        }
        catch (GeneralizedException e) {
            throw new ViewFailedException(e);
        }
        try {
            UserManagement userManagement = new UserManagement(Application.getApplication());
            users = userManagement.getUserDescriptors();
        }
        catch (SQLException e) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
            throw new ViewFailedException(e);
        }
        catch (NoDatabaseConnectionException e) {
            Application.getApplication().logExceptionEvent(EventLogMessage.EventType.DATABASE_FAILURE, (Throwable)e);
            throw new ViewFailedException(e);
        }
        data.put("users", users);
        data.put("ADMINISTRATIVELY_LOCKED", (Object)UserManagement.AccountStatus.ADMINISTRATIVELY_LOCKED);
        data.put("BRUTE_FORCE_LOCKED", (Object)UserManagement.AccountStatus.BRUTE_FORCE_LOCKED);
        data.put("DISABLED", (Object)UserManagement.AccountStatus.DISABLED);
        data.put("INVALID_USER", (Object)UserManagement.AccountStatus.INVALID_USER);
        data.put("VALID_USER", (Object)UserManagement.AccountStatus.VALID_USER);
        TemplateLoader.renderToResponse("Users.ftl", data, response);
        return true;
    }
}

