/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.web.views;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lukemurphey.nsia.scan.DefinitionMatch;
import net.lukemurphey.nsia.scan.HttpDefinitionScanResult;
import net.lukemurphey.nsia.scan.HttpSeekingScanResult;
import net.lukemurphey.nsia.web.RequestContext;
import net.lukemurphey.nsia.web.URLInvalidException;
import net.lukemurphey.nsia.web.View;
import net.lukemurphey.nsia.web.ViewFailedException;
import net.lukemurphey.nsia.web.ViewNotFoundException;

public class WebDiscoveryScanResultExport
extends View {
    public static final String VIEW_NAME = "scan_result_export";

    public WebDiscoveryScanResultExport() {
        super("ScanResultExport", VIEW_NAME, Pattern.compile("[0-9]+"));
    }

    @Override
    protected boolean process(HttpServletRequest request, HttpServletResponse response, RequestContext context, String[] args, Map<String, Object> data) throws ViewFailedException, URLInvalidException, IOException, ViewNotFoundException {
        HttpSeekingScanResult scanResult = (HttpSeekingScanResult)data.get("scanResult");
        HttpDefinitionScanResult[] findings = scanResult.getFindings();
        PrintWriter responseWriter = response.getWriter();
        CSVWriter writer = new CSVWriter((Writer)responseWriter);
        String[] header = new String[]{"URL", "Content Type", "Definition Name", "Severity", "Message"};
        writer.writeNext(header);
        HttpDefinitionScanResult[] httpDefinitionScanResultArray = findings;
        int n = findings.length;
        int n2 = 0;
        while (n2 < n) {
            HttpDefinitionScanResult finding = httpDefinitionScanResultArray[n2];
            DefinitionMatch[] matches = finding.getDefinitionMatches();
            String url = finding.getUrl().toExternalForm();
            String contentType = finding.getContentType();
            if (matches == null || matches.length == 0) {
                writer.writeNext(new String[]{url, contentType, "", "", ""});
            } else {
                DefinitionMatch[] definitionMatchArray = matches;
                int n3 = matches.length;
                int n4 = 0;
                while (n4 < n3) {
                    DefinitionMatch definitionMatch = definitionMatchArray[n4];
                    writer.writeNext(new String[]{url, contentType, definitionMatch.getDefinitionName(), definitionMatch.getSeverity().toString(), definitionMatch.getMessage()});
                    ++n4;
                }
            }
            ++n2;
        }
        return true;
    }
}

