/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.xmlRpcInterface;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.GroupManagement;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.trustBoundary.ApiGroupManagement;
import net.lukemurphey.nsia.xmlRpcInterface.XmlrpcHandler;

public class XmlrpcGroupManagement
extends XmlrpcHandler {
    private ApiGroupManagement untrustGroupManagement;

    public XmlrpcGroupManagement(Application appRes) {
        super(appRes);
        this.untrustGroupManagement = new ApiGroupManagement(appRes);
    }

    public int getGroupId(String sessionIdentifier, String groupName) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        return this.untrustGroupManagement.getGroupId(sessionIdentifier, groupName);
    }

    public int addGroup(String sessionIdentifier, String groupName, String groupDescription) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        return this.untrustGroupManagement.addGroup(sessionIdentifier, groupName, groupDescription);
    }

    public boolean updateGroupInfo(String sessionIdentifier, int groupId, String groupName, String groupDescription) throws SQLException, NoDatabaseConnectionException, InputValidationException, GeneralizedException, InsufficientPermissionException, NoSessionException {
        return this.untrustGroupManagement.updateGroupInfo(sessionIdentifier, groupId, groupName, groupDescription);
    }

    public boolean disableGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.untrustGroupManagement.disableGroup(sessionIdentifier, groupId);
    }

    public boolean deleteGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.untrustGroupManagement.deleteGroup(sessionIdentifier, groupId);
    }

    public boolean enableGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.untrustGroupManagement.enableGroup(sessionIdentifier, groupId);
    }

    public Hashtable<String, Object> getGroupDescriptor(String sessionIdentifier, int groupId) throws SQLException, NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        GroupManagement.GroupDescriptor groupDescriptor = this.untrustGroupManagement.getGroupDescriptor(sessionIdentifier, groupId);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("GroupName", groupDescriptor.getGroupName());
        hashtable.put("GroupDescription", groupDescriptor.getDescription());
        hashtable.put("GroupID", groupDescriptor.getGroupId());
        hashtable.put("GroupStatus", groupDescriptor.getGroupState().ordinal());
        return hashtable;
    }

    public Hashtable<String, Object> getGroupDescriptor(String sessionIdentifier, String groupName) throws SQLException, NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        GroupManagement.GroupDescriptor groupDescriptor = this.untrustGroupManagement.getGroupDescriptor(sessionIdentifier, groupName);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("GroupName", groupDescriptor.getGroupName());
        hashtable.put("GroupDescription", groupDescriptor.getDescription());
        hashtable.put("GroupID", groupDescriptor.getGroupId());
        hashtable.put("GroupStatus", groupDescriptor.getGroupState().ordinal());
        return hashtable;
    }

    public boolean addUserToGroup(String sessionIdentifier, int userId, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.untrustGroupManagement.addUserToGroup(sessionIdentifier, userId, groupId);
    }

    public boolean removeUserFromGroup(String sessionIdentifier, int userId, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.untrustGroupManagement.removeUserFromGroup(sessionIdentifier, userId, groupId);
    }

    public Vector<Hashtable<String, Object>> getGroupDescriptors(String sessionIdentifier) throws SQLException, NoSessionException, GeneralizedException, InsufficientPermissionException {
        GroupManagement.GroupDescriptor[] groupDescriptors = this.untrustGroupManagement.getGroupDescriptors(sessionIdentifier);
        Vector<Hashtable<String, Object>> groupDescVector = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < groupDescriptors.length) {
            Hashtable<String, Object> groupDesc = new Hashtable<String, Object>();
            GroupManagement.GroupDescriptor groupDescriptor = groupDescriptors[c];
            groupDesc.put("GroupName", groupDescriptor.getGroupName());
            groupDesc.put("GroupDescription", groupDescriptor.getDescription());
            groupDesc.put("GroupID", groupDescriptor.getGroupId());
            groupDesc.put("GroupStatus", groupDescriptor.getGroupState().ordinal());
            groupDescVector.add(groupDesc);
            ++c;
        }
        return groupDescVector;
    }
}

