/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.xmlRpcInterface;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupScanResult;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.scan.ScanRule;
import net.lukemurphey.nsia.trustBoundary.ApiScanData;
import net.lukemurphey.nsia.xmlRpcInterface.XmlrpcHandler;

public class XmlrpcScanData
extends XmlrpcHandler {
    private ApiScanData untrustScanData;

    public XmlrpcScanData(Application appRes) {
        super(appRes);
        this.untrustScanData = new ApiScanData(appRes);
    }

    public Vector<Hashtable<String, Object>> getSiteGroupStatus(String sessionIdentifier) throws GeneralizedException, NoSessionException {
        SiteGroupScanResult[] siteGroupScanResults = this.untrustScanData.getSiteGroupStatus(sessionIdentifier);
        Vector<Hashtable<String, Object>> results = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < siteGroupScanResults.length) {
            results.add(siteGroupScanResults[c].toHashtable());
            ++c;
        }
        return results;
    }

    public Hashtable<String, Object> getSiteGroupStatus(String sessionIdentifier, int siteGroupId) throws GeneralizedException, NoSessionException, InsufficientPermissionException, NotFoundException {
        SiteGroupScanResult scanResult = this.untrustScanData.getSiteGroupStatus(sessionIdentifier, siteGroupId);
        if (scanResult != null) {
            return scanResult.toHashtable();
        }
        return null;
    }

    public Hashtable<String, Object> getRule(String sessionIdentifier, double ruleId) throws GeneralizedException, NoSessionException, NotFoundException, InsufficientPermissionException {
        ApiScanData scanData = new ApiScanData(Application.getApplication());
        ScanRule scanRule = scanData.getScanRule(sessionIdentifier, (long)ruleId);
        return scanRule.toHashtable();
    }

    public String getRuleType(String sessionIdentifier, double ruleId) throws SQLException, NoSessionException, GeneralizedException {
        return this.untrustScanData.getRuleType(sessionIdentifier, (long)ruleId);
    }

    public Hashtable<String, Object> getLastScanResult(String sessionIdentifier, long ruleId) throws SQLException, NoSessionException, GeneralizedException {
        ScanResult scanResult = this.untrustScanData.getLastScanResult(sessionIdentifier, ruleId);
        if (scanResult == null) {
            return null;
        }
        return scanResult.toHashtable();
    }

    public Hashtable<String, Object> getScanResult(String sessionIdentifier, long ruleId) throws SQLException, NoSessionException, GeneralizedException {
        ScanResult scanResult = this.untrustScanData.getScanResult(sessionIdentifier, ruleId);
        if (scanResult == null) {
            return null;
        }
        return scanResult.toHashtable();
    }
}

