/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.xmlRpcInterface;

import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.eventlog.EventLogMessage;
import net.lukemurphey.nsia.scan.HttpStaticScanRule;
import net.lukemurphey.nsia.scan.ScanResult;
import net.lukemurphey.nsia.trustBoundary.ApiScannerController;
import net.lukemurphey.nsia.xmlRpcInterface.XmlrpcHandler;

public class XmlrpcScannerController
extends XmlrpcHandler {
    private ApiScannerController untrustScanner;

    public XmlrpcScannerController(Application appRes) {
        super(appRes);
        this.untrustScanner = new ApiScannerController(appRes);
    }

    public Hashtable<String, Object> scanRule(String sessionIdentifier, int ruleId, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        ScanResult scanResult = this.untrustScanner.scanRule(sessionIdentifier, ruleId, archiveResults);
        return scanResult.toHashtable();
    }

    public boolean deleteRule(String sessionIdentifier, int ruleId) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        return this.untrustScanner.deleteRule(sessionIdentifier, ruleId);
    }

    public Vector<Hashtable<String, Object>> scanSiteGroup(String sessionIdentifier, int siteGroupId, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        ScanResult[] scanResults = this.untrustScanner.scanSiteGroup(sessionIdentifier, siteGroupId, archiveResults);
        Vector<Hashtable<String, Object>> scanResultsVector = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < scanResults.length) {
            scanResultsVector.add(scanResults[c].toHashtable());
            ++c;
        }
        return scanResultsVector;
    }

    public Vector<Hashtable<String, Object>> scanAllRules(String sessionIdentifier, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        ScanResult[] scanResults = this.untrustScanner.scanAllRules(sessionIdentifier, archiveResults);
        Vector<Hashtable<String, Object>> scanResultsVector = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < scanResults.length) {
            scanResultsVector.add(scanResults[c].toHashtable());
            ++c;
        }
        return scanResultsVector;
    }

    public Vector<Hashtable<String, Object>> scanExpiredRules(String sessionIdentifier, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        ScanResult[] scanResults = this.untrustScanner.scanExpiredRules(sessionIdentifier, archiveResults);
        Vector<Hashtable<String, Object>> scanResultsVector = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < scanResults.length) {
            scanResultsVector.add(scanResults[c].toHashtable());
            ++c;
        }
        return scanResultsVector;
    }

    public Vector<Hashtable<String, Object>> scanUpdatedRules(String sessionIdentifier, boolean archiveResults) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        ScanResult[] scanResults = this.untrustScanner.scanUpdatedRules(sessionIdentifier, archiveResults);
        Vector<Hashtable<String, Object>> scanResultsVector = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < scanResults.length) {
            scanResultsVector.add(scanResults[c].toHashtable());
            ++c;
        }
        return scanResultsVector;
    }

    public void disableScanning(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.untrustScanner.disableScanning(sessionIdentifier);
    }

    public void enableScanning(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.untrustScanner.enableScanning(sessionIdentifier);
    }

    public Integer getMaxScanThreads(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        return this.untrustScanner.getMaxScanThreads(sessionIdentifier);
    }

    public Double getPollingLoopFrequency(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        return new Double(this.untrustScanner.getPollingLoopFrequency(sessionIdentifier));
    }

    public void setMaxScanThreads(String sessionIdentifier, int threadCount) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.untrustScanner.setMaxScanThreads(sessionIdentifier, threadCount);
    }

    public void setPollingLoopFrequency(String sessionIdentifier, int pollingFrequency) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        this.untrustScanner.setPollingLoopFrequency(sessionIdentifier, pollingFrequency);
    }

    public int getScanningState(String sessionIdentifier) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        return this.untrustScanner.getScanningState(sessionIdentifier).ordinal();
    }

    public long createRule(Hashtable<String, Object> hashtable, int siteGroupId) throws MalformedURLException, GeneralizedException {
        if (hashtable == null) {
            return -1L;
        }
        String classType = (String)hashtable.get("Class");
        if (classType.matches("HttpScan")) {
            HttpStaticScanRule httpScanRule = HttpStaticScanRule.getFromHashtable(hashtable);
            try {
                return httpScanRule.saveToDatabase();
            }
            catch (IllegalStateException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.INTERNAL_ERROR, (Throwable)e);
                throw new GeneralizedException(e);
            }
            catch (SQLException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                throw new GeneralizedException(e);
            }
            catch (NoDatabaseConnectionException e) {
                this.appRes.logExceptionEvent(EventLogMessage.EventType.SQL_EXCEPTION, (Throwable)e);
                throw new GeneralizedException(e);
            }
        }
        return -1L;
    }
}

