/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.xmlRpcInterface;

import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.SessionManagement;
import net.lukemurphey.nsia.trustBoundary.ApiSessionManagement;
import net.lukemurphey.nsia.xmlRpcInterface.XmlrpcHandler;

public class XmlrpcSession
extends XmlrpcHandler {
    protected ApiSessionManagement sessionManager;

    public XmlrpcSession(Application appRes) {
        super(appRes);
        this.sessionManager = new ApiSessionManagement(appRes);
    }

    public String authenticate(String userName, String password) throws GeneralizedException {
        String sessionIdentifier = this.sessionManager.authenticate(userName, password);
        if (sessionIdentifier == null) {
            return "";
        }
        return sessionIdentifier;
    }

    public boolean terminateSession(String sessionIdentifier) throws GeneralizedException {
        return this.sessionManager.terminateSession(sessionIdentifier);
    }

    public boolean terminateSession(String sessionIdentifier, int trackingNumber) throws GeneralizedException, InsufficientPermissionException, NoSessionException {
        return this.sessionManager.terminateSession(sessionIdentifier, trackingNumber);
    }

    public int getSessionStatus(String sessionIdentifier) throws GeneralizedException {
        return this.sessionManager.getSessionStatus(sessionIdentifier);
    }

    public String refreshSessionIdentifier(String sessionIdentifier) throws GeneralizedException {
        return this.sessionManager.refreshSessionIdentifier(sessionIdentifier);
    }

    public int disableUserSessions(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.sessionManager.disableUserSessions(sessionIdentifier, userId);
    }

    public Vector<Hashtable<String, Object>> getUserSessions(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        this.sessionManager.getUserSessions(sessionIdentifier);
        Vector<Hashtable<String, Object>> userSessions = new Vector<Hashtable<String, Object>>();
        SessionManagement.SessionInfo[] currentSessions = this.sessionManager.getUserSessions(sessionIdentifier);
        int c = 0;
        while (c < currentSessions.length) {
            Hashtable<String, Object> sessInfo = new Hashtable<String, Object>();
            sessInfo.put("LastActivity", Double.valueOf(currentSessions[c].getLastActivity().getTime()));
            sessInfo.put("SessionCreated", Double.valueOf(currentSessions[c].getSessionCreated().getTime()));
            sessInfo.put("SessionStatus", currentSessions[c].getSessionStatus().getStatusId());
            sessInfo.put("TrackingNumber", Double.valueOf(currentSessions[c].getTrackingNumber()));
            sessInfo.put("UserId", Integer.valueOf(String.valueOf(currentSessions[c].getUserId())));
            sessInfo.put("UserName", String.valueOf(currentSessions[c].getUserName()));
            userSessions.add(sessInfo);
            ++c;
        }
        return userSessions;
    }
}

