/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.xmlRpcInterface;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.NoDatabaseConnectionException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.SiteGroupManagement;
import net.lukemurphey.nsia.trustBoundary.ApiSiteGroupManagement;
import net.lukemurphey.nsia.xmlRpcInterface.XmlrpcHandler;

public class XmlrpcSiteGroupManagement
extends XmlrpcHandler {
    private ApiSiteGroupManagement siteGroupManager;

    public XmlrpcSiteGroupManagement(Application appRes) {
        super(appRes);
        this.siteGroupManager = new ApiSiteGroupManagement(appRes);
    }

    public long getGroupId(String sessionIdentifier, String groupName) throws GeneralizedException, NoSessionException, InsufficientPermissionException, InputValidationException {
        return this.siteGroupManager.getGroupId(sessionIdentifier, groupName);
    }

    public long addGroup(String sessionIdentifier, String groupName, String groupDescription) throws GeneralizedException, InsufficientPermissionException, NoSessionException, InputValidationException {
        return this.siteGroupManager.addGroup(sessionIdentifier, groupName, groupDescription);
    }

    public boolean updateGroupInfo(String sessionIdentifier, int groupId, String groupName, String groupDescription) throws SQLException, NoDatabaseConnectionException, InputValidationException, GeneralizedException, InsufficientPermissionException, NoSessionException {
        return this.siteGroupManager.updateGroupInfo(sessionIdentifier, groupId, groupName, groupDescription);
    }

    public boolean disableGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.siteGroupManager.disableGroup(sessionIdentifier, groupId);
    }

    public boolean enableGroup(String sessionIdentifier, int groupId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.siteGroupManager.enableGroup(sessionIdentifier, groupId);
    }

    public Hashtable<String, Object> getGroupDescriptor(String sessionIdentifier, int groupId) throws SQLException, NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        SiteGroupManagement.SiteGroupDescriptor groupDescriptor = this.siteGroupManager.getGroupDescriptor(sessionIdentifier, groupId);
        return groupDescriptor.toHashtable();
    }

    public Hashtable<String, Object> getGroupDescriptor(String sessionIdentifier, String groupName) throws SQLException, NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        SiteGroupManagement.SiteGroupDescriptor groupDescriptor = this.siteGroupManager.getGroupDescriptor(sessionIdentifier, groupName);
        hashtable.put("SiteGroupName", groupDescriptor.getGroupName());
        hashtable.put("SiteGroupDescription", groupDescriptor.getDescription());
        hashtable.put("SiteGroupID", groupDescriptor.getGroupId());
        hashtable.put("SiteGroupStatus", groupDescriptor.getGroupState().ordinal());
        return hashtable;
    }

    public Vector<Hashtable<String, Object>> getGroupDescriptors(String sessionIdentifier) throws SQLException, NoSessionException, GeneralizedException, InsufficientPermissionException {
        SiteGroupManagement.SiteGroupDescriptor[] groupDescriptors = this.siteGroupManager.getGroupDescriptors(sessionIdentifier);
        Vector<Hashtable<String, Object>> groupDescVector = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < groupDescriptors.length) {
            Hashtable<String, Object> groupDesc = new Hashtable<String, Object>();
            SiteGroupManagement.SiteGroupDescriptor groupDescriptor = groupDescriptors[c];
            groupDesc.put("SiteGroupName", groupDescriptor.getGroupName());
            groupDesc.put("SiteGroupDescription", groupDescriptor.getDescription());
            groupDesc.put("SiteGroupID", groupDescriptor.getGroupId());
            groupDesc.put("SiteGroupStatus", groupDescriptor.getGroupState().ordinal());
            groupDescVector.add(groupDesc);
            ++c;
        }
        return groupDescVector;
    }
}

