/*
 * Decompiled with CFR 0.152.
 */
package net.lukemurphey.nsia.xmlRpcInterface;

import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;
import net.lukemurphey.nsia.Application;
import net.lukemurphey.nsia.DisallowedOperationException;
import net.lukemurphey.nsia.GeneralizedException;
import net.lukemurphey.nsia.InputValidationException;
import net.lukemurphey.nsia.InsufficientPermissionException;
import net.lukemurphey.nsia.InvalidLocalPartException;
import net.lukemurphey.nsia.NoSessionException;
import net.lukemurphey.nsia.NotFoundException;
import net.lukemurphey.nsia.PasswordInvalidException;
import net.lukemurphey.nsia.UserManagement;
import net.lukemurphey.nsia.trustBoundary.ApiUserManagement;
import net.lukemurphey.nsia.xmlRpcInterface.XmlrpcHandler;

public class XmlrpcUserManagement
extends XmlrpcHandler {
    public static final String DEFAULT_HASH_ALGORITHM = "sha-512";
    public static final long DEFAULT_HASH_ITERATION_COUNT = 10000L;
    protected ApiUserManagement userManager;

    public XmlrpcUserManagement(Application appRes) {
        super(appRes);
        this.userManager = new ApiUserManagement(appRes);
    }

    public void clearAuthFailedCount(String sessionIdentifier, String userName) throws GeneralizedException, InputValidationException, InsufficientPermissionException, NoSessionException {
        this.userManager.clearAuthFailedCount(sessionIdentifier, userName);
    }

    public double addAccount(String sessionIdentifier, String userName, String realName, String password, String emailAddress, boolean unrestricted) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, UnknownHostException, InvalidLocalPartException, DisallowedOperationException {
        return this.userManager.addAccount(sessionIdentifier, userName, realName, password, emailAddress, unrestricted);
    }

    public boolean changePassword(String sessionIdentifier, int userId, String newPassword, String confirmationPassword) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, PasswordInvalidException {
        return this.userManager.changePassword(sessionIdentifier, userId, newPassword, confirmationPassword);
    }

    public boolean deleteAccount(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, DisallowedOperationException {
        return this.userManager.deleteAccount(sessionIdentifier, userId);
    }

    public boolean disableAccount(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, DisallowedOperationException {
        return this.userManager.disableAccount(sessionIdentifier, userId);
    }

    public boolean enableAccount(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        return this.userManager.enableAccount(sessionIdentifier, userId);
    }

    public Hashtable<String, Object> getUserDescriptor(String sessionIdentifier, int userId) throws NoSessionException, GeneralizedException, InsufficientPermissionException, NotFoundException {
        UserManagement.UserDescriptor userDescriptor = this.userManager.getUserDescriptor(sessionIdentifier, userId);
        Hashtable<String, Object> userInfo = new Hashtable<String, Object>();
        if (userDescriptor.getEmailAddress() == null) {
            userInfo.put("EmailAddress", "");
        } else {
            userInfo.put("EmailAddress", userDescriptor.getEmailAddress());
        }
        userInfo.put("Username", userDescriptor.getUserName());
        userInfo.put("UserID", userDescriptor.getUserID());
        userInfo.put("UnrestrictedAccount", userDescriptor.isUnrestricted());
        userInfo.put("AccountStatus", userDescriptor.getAccountStatus().ordinal());
        userInfo.put("Fullname", userDescriptor.getFullname());
        userInfo.put("BruteForceLocked", userDescriptor.isBruteForceLocked());
        return userInfo;
    }

    public Vector<Hashtable<String, Object>> getUserDescriptors(String sessionIdentifier) throws NoSessionException, GeneralizedException, InsufficientPermissionException {
        UserManagement.UserDescriptor[] userDescriptor = this.userManager.getUserDescriptors(sessionIdentifier);
        Vector<Hashtable<String, Object>> userDescs = new Vector<Hashtable<String, Object>>();
        int c = 0;
        while (c < userDescriptor.length) {
            Hashtable<String, Object> userInfo = new Hashtable<String, Object>();
            if (userDescriptor[c].getEmailAddress() != null) {
                userInfo.put("EmailAddress", userDescriptor[c].getEmailAddress().toString());
            }
            userInfo.put("Username", userDescriptor[c].getUserName());
            userInfo.put("UserID", userDescriptor[c].getUserID());
            userInfo.put("UnrestrictedAccount", userDescriptor[c].isUnrestricted());
            userInfo.put("AccountStatus", userDescriptor[c].getAccountStatus().ordinal());
            if (userDescriptor[c].getFullname() == null) {
                userInfo.put("Fullname", "");
            } else {
                userInfo.put("Fullname", userDescriptor[c].getFullname());
            }
            userInfo.put("BruteForceLocked", userDescriptor[c].isBruteForceLocked());
            userDescs.add(userInfo);
            ++c;
        }
        return userDescs;
    }

    public Hashtable<String, Object> getUserDescriptor(String sessionIdentifier, String userName) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException, NotFoundException {
        UserManagement.UserDescriptor userDescriptor = this.userManager.getUserDescriptor(sessionIdentifier, userName);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("EmailAddress", userDescriptor.getEmailAddress().toString());
        hashtable.put("Username", userDescriptor.getUserName());
        hashtable.put("UserID", userDescriptor.getUserID());
        hashtable.put("UnrestrictedAccount", String.valueOf(userDescriptor.isUnrestricted()));
        hashtable.put("AccountStatus", userDescriptor.getAccountStatus().ordinal());
        hashtable.put("Fullname", userDescriptor.getFullname());
        hashtable.put("BruteForceLocked", userDescriptor.isBruteForceLocked());
        return hashtable;
    }

    public int getUserId(String sessionIdentifier, String userName) throws NoSessionException, GeneralizedException, InsufficientPermissionException, InputValidationException {
        return (int)this.userManager.getUserId(sessionIdentifier, userName);
    }

    public boolean updateAccount(String sessionIdentifier, int userId, String userName, String realName, String emailAddress) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        return this.userManager.updateAccount(sessionIdentifier, userId, userName, realName, emailAddress);
    }

    public boolean updateAccount(String sessionIdentifier, int userId, boolean accountEnabled, String userName, String realName, String emailAddress) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        return this.userManager.updateAccount(sessionIdentifier, userId, accountEnabled, userName, realName, emailAddress);
    }

    public boolean updateAccountEx(String sessionIdentifier, int userId, String userName, String realName, String emailAddress, boolean unrestricted) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        return this.userManager.updateAccountEx(sessionIdentifier, userId, userName, realName, emailAddress, unrestricted);
    }

    public boolean updateAccountEx(String sessionIdentifier, int userId, boolean accountEnabled, String userName, String realName, String emailAddress, boolean unrestricted) throws InsufficientPermissionException, GeneralizedException, NoSessionException, UnknownHostException, InputValidationException, InvalidLocalPartException, DisallowedOperationException {
        return this.userManager.updateAccountEx(sessionIdentifier, userId, accountEnabled, userName, realName, emailAddress, unrestricted);
    }
}

