#!/usr/bin/python
'''
//=============================================================================
//
//  File : ufo_alicemcgui.py
//  Creation date : Sun Mar 03 00:00:48 CEST 2012
//  Working on this file:   asterix (Cristian Steri)
//                          Grifisx (Antonino G. Imbesi)
//   This file is part of the Ufo Wardriving distribution
//
//  Websites: http://ufo-wardriving.com
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//  This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
'''

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *

from core.ufo_define import *

import sys, os.path
import subprocess
import re
import platform

from core.ufo_picsfinder import get_icon
from core.ufo_define import *
        
class UFOMagicCalculator(QWidget):
    def __init__(self, parent=None):
        super( UFOMagicCalculator, self).__init__(parent)
        self.setMaximumHeight(300)
        self.setMaximumWidth(300)
        self.setWindowTitle("Alice Magic Calc")
        self.setWindowIcon(get_icon("magic.png"))
        
        upHBoxLayout = QHBoxLayout()
        upHBoxLayout.setSpacing(5)
        
        downHBoxLayout = QHBoxLayout()
        downHBoxLayout.setSpacing(5)
        
        ddHBoxLayout = QHBoxLayout()
        ddHBoxLayout.setSpacing(5)

        dHBoxLayout = QHBoxLayout()
        dHBoxLayout.setSpacing(5)
            
        vBoxLayout = QVBoxLayout(self)
        vBoxLayout.setSpacing(5)

        self.serialLabel = QLabel(self)
        self.serialLabel.setText(_("Serial"))
        
        self.serialLineEdit= QLineEdit(self)
 #       self.serialEdit.setInputMask("HH:HH:HH:HH:HH:HH;_")

        self.macLabel = QLabel(self)
        self.macLabel.setText(_("MAC Address"))
        
        self.macLineEdit= QLineEdit(self)
        self.macLineEdit.setInputMask("HH:HH:HH:HH:HH:HH;_")

        self.ssidLabel = QLabel(self)
        self.ssidLabel.setText("SSID")
        
        self.ssidLineEdit= QLineEdit(self)
 #       self.ssidEdit.setInputMask("HH:HH:HH:HH:HH:HH;_")
        
        self.addPushButton = QPushButton(_("Add to magic numbers list"),self)
        
        vBoxLayout.addLayout(upHBoxLayout)
        vBoxLayout.addLayout(downHBoxLayout)
        vBoxLayout.addLayout(dHBoxLayout)
        vBoxLayout.addLayout(ddHBoxLayout)
        
        upHBoxLayout.addWidget(self.serialLabel)
        upHBoxLayout.addWidget(self.serialLineEdit)
        downHBoxLayout.addWidget(self.ssidLabel)
        downHBoxLayout.addWidget(self.ssidLineEdit)
        dHBoxLayout.addWidget(self.macLabel)
        dHBoxLayout.addWidget(self.macLineEdit)
                
        ddHBoxLayout.addWidget(self.addPushButton)
        
        self.addPushButton.clicked.connect(self.slotAdd)

   
    def mn_calc(self):
        SSID = self.ssidLineEdit.text()
        if "Alice-" in SSID:
            SSID = SSID.replace("Alice-","")
            if len(SSID) == 8:
                try: 
                    int(SSID)
                except ValueError:
                    return False
            else:
                return False
        else:
            if len(SSID) == 8:
                try:
                    int(SSID)
                except ValueError:
                    return False
            else:
                return False
        SERIAL = self.serialLineEdit.text()
        if "X" in SERIAL:
            SN2 = SERIAL.split("X")[1]
            SN1 = SERIAL.split("X")[0]
        elif "x" in SERIAL:
            SN2 = SERIAL.split("x")[1]
            SN1 = SERIAL.split("x")[0]
        else:
            return False
        try:
            int(SN2)
        except ValueError:
            return False
        try:
            int(SN1)
        except ValueError:
            return False
        Ka =13
        Qa=int(SSID)-(Ka*int(SN2))
        Kb = 8
        Qb=int(SSID)-(Kb*int(SN2))
        MAC1= self.macLineEdit.text().replace(":","").trimmed().left(6)
        self.MAGICLINE1 = SSID.left(3)+","+SN1+","+str(Ka)+","+str(Qa)+","+str(MAC1).upper()
        self.MAGICLINE2 = SSID.left(3)+","+SN1+","+str(Kb)+","+str(Qb)+","+str(MAC1).upper()
        qDebug(self.MAGICLINE1+"\n"+self.MAGICLINE2)


    def slotAdd(self):
        mn_calc = self.mn_calc()
        if mn_calc == False:
            QMessageBox.information(self, _("Warning"), _("Verify the data entered"), QMessageBox.Ok)
            return
        else:
            p = CONFIG_PATH+"agpf_config.txt"
            control = os.path.isfile(p)
            if control != False:
                f = open(p,"a")
                m = self.MAGICLINE1.trimmed()+"\n"+self.MAGICLINE2.trimmed()+"\n"
                f.write(m)
                f.close()
                QMessageBox.information(self, _("Added"), _("Successful added to the list"), QMessageBox.Ok)
                return 
