/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.crypto;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import net.seleucus.wsp.crypto.WebSpaUtils;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.ArrayUtils;

public class ActionNumberCrypto
extends WebSpaUtils {
    public static byte[] getHashedActionNumberInTimeWithSalt(CharSequence passPhrase, int actionNumber, long currentTimeMinutes, byte[] salt) {
        byte[] passBytes = passPhrase.toString().getBytes(Charsets.UTF_8);
        byte[] actionBytes = ByteBuffer.allocate(4).putInt(actionNumber).array();
        byte[] timeBytes = ByteBuffer.allocate(8).putLong(currentTimeMinutes).array();
        byte[] sortedBytes = new byte[passBytes.length + timeBytes.length - 4 + 1];
        System.arraycopy(passBytes, 0, sortedBytes, 0, passBytes.length);
        System.arraycopy(timeBytes, 4, sortedBytes, passBytes.length, timeBytes.length - 4);
        System.arraycopy(actionBytes, actionBytes.length - 1, sortedBytes, sortedBytes.length - 1, 1);
        byte[] allBytes = ArrayUtils.addAll(sortedBytes, salt);
        byte[] hashedBytes = ArrayUtils.subarray(ActionNumberCrypto.digest(allBytes), 0, 20);
        return ArrayUtils.addAll(salt, hashedBytes);
    }

    public static byte[] getHashedActionNumberNowWithSalt(CharSequence passPhrase, int actionNumber, byte[] salt) {
        long currentTimeMinutes = System.currentTimeMillis() / 60000L;
        return ActionNumberCrypto.getHashedActionNumberInTimeWithSalt(passPhrase, actionNumber, currentTimeMinutes, salt);
    }

    public static byte[] getHashedActionNumberInTime(CharSequence passPhrase, int actionNumber, long currentTimeMinutes) {
        SecureRandom scRandom = new SecureRandom();
        byte[] randomBytes = new byte[4];
        scRandom.nextBytes(randomBytes);
        return ActionNumberCrypto.getHashedActionNumberInTimeWithSalt(passPhrase, actionNumber, currentTimeMinutes, randomBytes);
    }

    public static byte[] getHashedActionNumberNow(CharSequence passPhrase, int actionNumber) {
        long currentTimeMinutes = System.currentTimeMillis() / 60000L;
        SecureRandom scRandom = new SecureRandom();
        byte[] randomBytes = new byte[4];
        scRandom.nextBytes(randomBytes);
        return ActionNumberCrypto.getHashedActionNumberInTimeWithSalt(passPhrase, actionNumber, currentTimeMinutes, randomBytes);
    }

    private ActionNumberCrypto() {
        throw new UnsupportedOperationException();
    }
}

