/*
 * Decompiled with CFR 0.152.
 */
package net.seleucus.wsp.server.commands;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.seleucus.wsp.server.WSServer;
import net.seleucus.wsp.server.commands.WSCommandOption;
import org.apache.commons.io.IOUtils;

public class WSHelpOptions
extends WSCommandOption {
    private static final String[] ARRAY_COMMANDS = new String[]{"action", "config", "help", "pass-phrase", "service", "shortcuts", "user"};
    private static final Set<String> SERVER_COMMANDS = new HashSet<String>(Arrays.asList(ARRAY_COMMANDS));
    private String option = "default";

    public WSHelpOptions(WSServer myServer) {
        super(myServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        int counter;
        int MAX_CHARS = 4096;
        InputStream fstream = ClassLoader.getSystemResourceAsStream("help/" + this.option);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = null;
        StringBuffer fileContents = new StringBuffer(4196);
        try {
            int currentChar;
            br = new BufferedReader(new InputStreamReader(in));
            for (counter = 0; (currentChar = in.read()) > 0 && counter < 4096; ++counter) {
                if ((currentChar < 32 || currentChar >= 127) && currentChar != 10) continue;
                fileContents.append((char)currentChar);
            }
            br.close();
            in.close();
        }
        catch (IOException e) {
            try {
                fileContents.append("Attempting to open the file caused an I/O Error:\n\n" + this.option);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(in);
        }
        IOUtils.closeQuietly(br);
        IOUtils.closeQuietly(in);
        if (counter == 4096) {
            fileContents.append("\n... stopped reading after 4096 characters.\n");
        }
        System.out.println(fileContents.toString());
    }

    @Override
    public boolean handle(String cmd) {
        boolean validCommand = false;
        this.option = "default";
        if (this.isValid(cmd)) {
            validCommand = true;
            this.execute();
        }
        return validCommand;
    }

    @Override
    protected boolean isValid(String cmd) {
        String[] params;
        boolean valid = false;
        if (cmd.equalsIgnoreCase("help") || cmd.equalsIgnoreCase("?")) {
            valid = true;
        } else if (cmd.startsWith("help") && (params = cmd.split(" ")).length > 1 && SERVER_COMMANDS.contains(params[1])) {
            this.option = params[1];
            valid = true;
        }
        return valid;
    }
}

